/*
 * Decompiled with CFR 0.152.
 */
package winstone.auth;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Node;
import winstone.AuthenticationHandler;
import winstone.AuthenticationRealm;
import winstone.Logger;
import winstone.WebAppConfiguration;
import winstone.WinstoneResourceBundle;
import winstone.auth.SecurityConstraint;

public abstract class BaseAuthenticationHandler
implements AuthenticationHandler {
    static final String ELEM_REALM_NAME = "realm-name";
    protected SecurityConstraint[] constraints;
    protected AuthenticationRealm realm;
    protected String realmName;
    public static final WinstoneResourceBundle AUTH_RESOURCES = new WinstoneResourceBundle("winstone.auth.LocalStrings");

    protected BaseAuthenticationHandler(Node loginConfigNode, List constraintNodes, Set rolesAllowed, AuthenticationRealm realm) {
        this.realm = realm;
        for (int m = 0; m < loginConfigNode.getChildNodes().getLength(); ++m) {
            Node loginElm = loginConfigNode.getChildNodes().item(m);
            if (loginElm.getNodeType() != 1 || !loginElm.getNodeName().equals(ELEM_REALM_NAME)) continue;
            this.realmName = WebAppConfiguration.getTextFromNode(loginElm);
        }
        this.constraints = new SecurityConstraint[constraintNodes.size()];
        for (int n = 0; n < this.constraints.length; ++n) {
            this.constraints[n] = new SecurityConstraint((Node)constraintNodes.get(n), rolesAllowed, n);
        }
    }

    public boolean processAuthentication(ServletRequest inRequest, ServletResponse inResponse, String pathRequested) throws IOException, ServletException {
        Logger.log(Logger.FULL_DEBUG, AUTH_RESOURCES, "BaseAuthenticationHandler.StartAuthCheck");
        HttpServletRequest request = (HttpServletRequest)inRequest;
        HttpServletResponse response = (HttpServletResponse)inResponse;
        if (!this.validatePossibleAuthenticationResponse(request, response, pathRequested)) {
            return false;
        }
        return this.doRoleCheck(request, response, pathRequested);
    }

    protected boolean doRoleCheck(HttpServletRequest request, HttpServletResponse response, String pathRequested) throws IOException, ServletException {
        boolean foundApplicable = false;
        for (int n = 0; n < this.constraints.length && !foundApplicable; ++n) {
            Logger.log(Logger.FULL_DEBUG, AUTH_RESOURCES, "BaseAuthenticationHandler.EvalConstraint", this.constraints[n].getName());
            if (!this.constraints[n].isApplicable(pathRequested, request.getMethod())) continue;
            Logger.log(Logger.FULL_DEBUG, AUTH_RESOURCES, "BaseAuthenticationHandler.ApplicableConstraint", this.constraints[n].getName());
            foundApplicable = true;
            if (this.constraints[n].needsSSL() && !request.isSecure()) {
                Logger.log(Logger.DEBUG, AUTH_RESOURCES, "BaseAuthenticationHandler.ConstraintNeedsSSL", this.constraints[n].getName());
                response.sendError(403, AUTH_RESOURCES.getString("BaseAuthenticationHandler.ConstraintNeedsSSL", this.constraints[n].getName()));
                return false;
            }
            if (!this.constraints[n].isAllowed(request)) {
                this.requestAuthentication(request, response, pathRequested);
                return false;
            }
            this.setNoCache(response);
        }
        Logger.log(Logger.FULL_DEBUG, AUTH_RESOURCES, "BaseAuthenticationHandler.PassedAuthCheck");
        return true;
    }

    protected void setNoCache(HttpServletResponse response) {
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "No-cache");
        response.setDateHeader("Expires", 1L);
    }

    protected abstract void requestAuthentication(HttpServletRequest var1, HttpServletResponse var2, String var3) throws IOException, ServletException;

    protected abstract boolean validatePossibleAuthenticationResponse(HttpServletRequest var1, HttpServletResponse var2, String var3) throws ServletException, IOException;
}

