/*
 * $Id: DynamicTreeSelectAction.java 528866 2007-04-14 20:19:20Z musachy $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.struts2.showcase;

import org.apache.struts2.showcase.ajax.tree.Category;

import com.opensymphony.xwork2.ActionSupport;

//START SNIPPET: treeExampleDynamicJavaSelected

public class DynamicTreeSelectAction extends ActionSupport {

    private long nodeId;
    private Category currentCategory;


    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }
    public long getNodeId() {
        return nodeId;
    }


    public String execute() throws Exception {
        currentCategory = Category.getById(nodeId);
        return SUCCESS;
    }


    public String getNodeName() {
        return currentCategory != null ? currentCategory.getName() : "Node not found";
    }
}

//START SNIPPET: treeExampleDynamicJavaSelected

