/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.tiles;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.views.freemarker.FreemarkerResult;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.context.TilesRequestContextWrapper;

public class StrutsTilesRequestContext
extends TilesRequestContextWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(StrutsTilesRequestContext.class);
    private String mask;

    public StrutsTilesRequestContext(TilesRequestContext context) {
        this(context, ".ftl");
    }

    public StrutsTilesRequestContext(TilesRequestContext context, String mask) {
        super(context);
        this.mask = mask;
    }

    public void dispatch(String include) throws IOException {
        if (include.endsWith(this.mask)) {
            this.include(include);
        } else {
            super.dispatch(include);
        }
    }

    public void include(String include) throws IOException {
        if (include.endsWith(this.mask)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Intercepting tiles include '" + include + "'. Processing as freemarker result.", new String[0]);
            }
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            HttpServletResponse response = (HttpServletResponse)this.getResponse();
            ActionContext ctx = ServletActionContext.getActionContext((HttpServletRequest)request);
            ActionInvocation invocation = ctx.getActionInvocation();
            try {
                FreemarkerResult result = new FreemarkerResult();
                result.setWriter((Writer)response.getWriter());
                Container container = ctx.getContainer();
                container.inject((Object)result);
                result.doExecute(include, invocation);
            }
            catch (Exception e) {
                LOG.error("Error invoking Freemarker template", (Throwable)e, new String[0]);
                throw new IOException("Error invoking Freemarker template." + e.getMessage());
            }
        } else {
            super.include(include);
        }
    }
}

