/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.jsf;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;

public class FacesSupport {
    private static final String LIFECYCLE_KEY = "lifecycle";
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final String FACES_ENABLED = "facesEnabled";

    protected FacesSupport() {
    }

    private Lifecycle getLifecycle() {
        return (Lifecycle)ActionContext.getContext().get(LIFECYCLE_KEY);
    }

    protected void setLifecycle(Lifecycle lifecycle) {
        ActionContext.getContext().put(LIFECYCLE_KEY, (Object)lifecycle);
    }

    protected void informPhaseListenersBefore(FacesContext facesContext, PhaseId phaseId) {
        Lifecycle lifecycle = this.getLifecycle();
        PhaseListener[] phaseListeners = lifecycle.getPhaseListeners();
        for (int i = 0; i < phaseListeners.length; ++i) {
            PhaseListener phaseListener = phaseListeners[i];
            int listenerPhaseId = phaseListener.getPhaseId().getOrdinal();
            if (listenerPhaseId != PhaseId.ANY_PHASE.getOrdinal() && listenerPhaseId != phaseId.getOrdinal()) continue;
            phaseListener.beforePhase(new PhaseEvent(FacesContext.getCurrentInstance(), phaseId, lifecycle));
        }
    }

    protected void informPhaseListenersAfter(FacesContext facesContext, PhaseId phaseId) {
        Lifecycle lifecycle = this.getLifecycle();
        PhaseListener[] phaseListeners = lifecycle.getPhaseListeners();
        for (int i = 0; i < phaseListeners.length; ++i) {
            PhaseListener phaseListener = phaseListeners[i];
            int listenerPhaseId = phaseListener.getPhaseId().getOrdinal();
            if (listenerPhaseId != PhaseId.ANY_PHASE.getOrdinal() && listenerPhaseId != phaseId.getOrdinal()) continue;
            phaseListener.afterPhase(new PhaseEvent(FacesContext.getCurrentInstance(), phaseId, lifecycle));
        }
    }

    protected boolean isResponseComplete(FacesContext facesContext, String phase, boolean before) {
        boolean flag = false;
        if (facesContext.getResponseComplete()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("exiting from lifecycle.execute in " + phase + " because getResponseComplete is true from one of the " + (before ? "before" : "after") + " listeners", new String[0]);
            }
            flag = true;
        }
        return flag;
    }

    protected boolean shouldRenderResponse(FacesContext facesContext, String phase, boolean before) {
        boolean flag = false;
        if (facesContext.getRenderResponse()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("exiting from lifecycle.execute in " + phase + " because getRenderResponse is true from one of the " + (before ? "before" : "after") + " listeners", new String[0]);
            }
            flag = true;
        }
        return flag;
    }
}

