/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.jsf;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.interceptor.Interceptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.NavigationHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.StrutsException;
import org.apache.struts2.jsf.FacesResult;
import org.apache.struts2.jsf.FacesSupport;
import org.apache.struts2.util.ClassLoaderUtils;

public class FacesSetupInterceptor
extends FacesSupport
implements Interceptor {
    private static final long serialVersionUID = -621512342655103941L;
    private String lifecycleId = "DEFAULT";
    private FacesContextFactory facesContextFactory;
    private Lifecycle lifecycle;
    private List<String> actionListener;
    private String defaultRenderKitId;
    private List<String> supportedLocale;
    private String defaultLocale;
    private String messageBundle;
    private List<String> navigationHandler;
    private List<String> propertyResolver;
    private List<String> stateManager;
    private List<String> variableResolver;
    private List<String> viewHandler;

    public void setLifecycleId(String id) {
        this.lifecycleId = id;
    }

    public void init() {
        Iterator<String> i;
        try {
            this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        }
        catch (Exception ex) {
            this.log.debug("Unable to initialize faces", (Throwable)ex, new String[0]);
            return;
        }
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        this.lifecycle = lifecycleFactory.getLifecycle(this.lifecycleId);
        Application application = ((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication();
        if (this.actionListener != null) {
            i = this.actionListener.iterator();
            application.setActionListener((ActionListener)this.getApplicationObject(ActionListener.class, i, application.getActionListener()));
        }
        if (this.defaultRenderKitId != null && this.defaultRenderKitId.length() > 0) {
            application.setDefaultRenderKitId(this.defaultRenderKitId);
        }
        if (this.messageBundle != null && this.messageBundle.length() > 0) {
            application.setMessageBundle(this.messageBundle);
        }
        if (this.supportedLocale != null) {
            ArrayList<Locale> locales = new ArrayList<Locale>();
            Iterator<String> i2 = this.supportedLocale.iterator();
            while (i2.hasNext()) {
                locales.add(this.toLocale(i2.next()));
            }
            application.setSupportedLocales(locales);
        }
        if (this.defaultLocale != null && this.defaultLocale.length() > 0) {
            application.setDefaultLocale(this.toLocale(this.defaultLocale));
        }
        if (this.navigationHandler != null) {
            i = this.navigationHandler.iterator();
            application.setNavigationHandler((NavigationHandler)this.getApplicationObject(NavigationHandler.class, i, application.getNavigationHandler()));
        }
        if (this.propertyResolver != null) {
            i = this.propertyResolver.iterator();
            application.setPropertyResolver((PropertyResolver)this.getApplicationObject(PropertyResolver.class, i, application.getPropertyResolver()));
        }
        if (this.stateManager != null) {
            i = this.stateManager.iterator();
            application.setStateManager((StateManager)this.getApplicationObject(StateManager.class, i, application.getStateManager()));
        }
        if (this.variableResolver != null) {
            i = this.variableResolver.iterator();
            application.setVariableResolver((VariableResolver)this.getApplicationObject(VariableResolver.class, i, application.getVariableResolver()));
        }
        if (this.viewHandler != null) {
            i = this.viewHandler.iterator();
            application.setViewHandler((ViewHandler)this.getApplicationObject(ViewHandler.class, i, application.getViewHandler()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(ActionInvocation invocation) throws Exception {
        if (this.facesContextFactory != null) {
            if (this.isFacesAction(invocation)) {
                invocation.getInvocationContext().put("facesEnabled", (Object)Boolean.TRUE);
                FacesContext facesContext = this.facesContextFactory.getFacesContext((Object)ServletActionContext.getServletContext(), (Object)ServletActionContext.getRequest(), (Object)ServletActionContext.getResponse(), this.lifecycle);
                this.setLifecycle(this.lifecycle);
                try {
                    String string = invocation.invoke();
                    return string;
                }
                finally {
                    facesContext.release();
                }
            }
        } else {
            throw new StrutsException("Unable to initialize jsf interceptors probably due missing JSF implementation libraries", (Object)invocation.getProxy().getConfig());
        }
        return invocation.invoke();
    }

    public void destroy() {
        this.facesContextFactory = null;
        this.lifecycle = null;
    }

    protected boolean isFacesAction(ActionInvocation inv) {
        ActionConfig config = inv.getProxy().getConfig();
        if (config != null) {
            ResultConfig resultConfig = (ResultConfig)config.getResults().get("success");
            Class<FacesResult> resClass = null;
            try {
                resClass = Class.forName(resultConfig.getClassName());
            }
            catch (ClassNotFoundException ex) {
                this.log.warn("Can't find result class, ignoring as a faces request", (Throwable)ex, new String[0]);
            }
            if (resClass != null && resClass.isAssignableFrom(FacesResult.class)) {
                return true;
            }
        }
        return false;
    }

    private Object getApplicationObject(Class interfaceClass, Iterator classNamesIterator, Object defaultObject) {
        Object current = defaultObject;
        while (classNamesIterator.hasNext()) {
            String implClassName = (String)classNamesIterator.next();
            Class implClass = null;
            try {
                implClass = ClassLoaderUtils.loadClass((String)implClassName, this.getClass());
            }
            catch (ClassNotFoundException e1) {
                throw new IllegalArgumentException("Class " + implClassName + " was not found.");
            }
            if (!interfaceClass.isAssignableFrom(implClass)) {
                throw new IllegalArgumentException("Class " + implClassName + " is no " + interfaceClass.getName());
            }
            if (current == null) {
                try {
                    current = implClass.newInstance();
                    continue;
                }
                catch (InstantiationException e) {
                    this.log.error(e.getMessage(), (Throwable)e, new String[0]);
                    throw new StrutsException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    this.log.error(e.getMessage(), (Throwable)e, new String[0]);
                    throw new StrutsException((Throwable)e);
                }
            }
            try {
                Constructor delegationConstructor = implClass.getConstructor(interfaceClass);
                try {
                    current = delegationConstructor.newInstance(current);
                }
                catch (InstantiationException e) {
                    this.log.error(e.getMessage(), (Throwable)e, new String[0]);
                    throw new StrutsException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    this.log.error(e.getMessage(), (Throwable)e, new String[0]);
                    throw new StrutsException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    this.log.error(e.getMessage(), (Throwable)e, new String[0]);
                    throw new StrutsException((Throwable)e);
                }
            }
            catch (NoSuchMethodException e) {
                try {
                    current = implClass.newInstance();
                }
                catch (InstantiationException e1) {
                    this.log.error(e.getMessage(), (Throwable)e, new String[0]);
                    throw new StrutsException((Throwable)e);
                }
                catch (IllegalAccessException e1) {
                    this.log.error(e.getMessage(), (Throwable)e, new String[0]);
                    throw new StrutsException((Throwable)e);
                }
            }
        }
        return current;
    }

    public void setActionListener(String actionListener) {
        if (this.actionListener == null) {
            this.actionListener = new ArrayList<String>();
        }
        String clean = actionListener.replaceAll("[ \t\r\n]", "");
        String[] actionListenerNames = clean.split(",");
        for (int i = 0; i < actionListenerNames.length; ++i) {
            this.actionListener.add(actionListenerNames[i]);
        }
    }

    public void setDefaultRenderKitId(String defaultRenderKitId) {
        String clean;
        this.defaultRenderKitId = clean = defaultRenderKitId.replaceAll("[ \t\r\n]", "");
    }

    public void setSupportedLocale(String supportedLocale) {
        if (this.supportedLocale == null) {
            this.supportedLocale = new ArrayList<String>();
        }
        String clean = supportedLocale.replaceAll("[ \t\r\n]", "");
        String[] supportedLocaleNames = clean.split(",");
        for (int i = 0; i < supportedLocaleNames.length; ++i) {
            this.supportedLocale.add(supportedLocaleNames[i]);
        }
    }

    public void setDefaultLocale(String defaultLocale) {
        String clean;
        this.defaultLocale = clean = defaultLocale.replaceAll("[ \t\r\n]", "");
    }

    public void setMessageBundle(String messageBundle) {
        String clean;
        this.messageBundle = clean = messageBundle.replaceAll("[ \t\r\n]", "");
    }

    public void setNavigationHandler(String navigationHandlerName) {
        if (this.navigationHandler == null) {
            this.navigationHandler = new ArrayList<String>();
        }
        String clean = navigationHandlerName.replaceAll("[ \t\r\n]", "");
        String[] navigationHandlerNames = clean.split(",");
        for (int i = 0; i < navigationHandlerNames.length; ++i) {
            this.navigationHandler.add(navigationHandlerNames[i]);
        }
    }

    public void setPropertyResolver(String propertyResolverName) {
        if (this.propertyResolver == null) {
            this.propertyResolver = new ArrayList<String>();
        }
        String clean = propertyResolverName.replaceAll("[ \t\r\n]", "");
        String[] propertyResolverNames = clean.split(",");
        for (int i = 0; i < propertyResolverNames.length; ++i) {
            this.propertyResolver.add(propertyResolverNames[i]);
        }
    }

    public void setStateManager(String stateManagerName) {
        if (this.stateManager == null) {
            this.stateManager = new ArrayList<String>();
        }
        String clean = stateManagerName.replaceAll("[ \t\r\n]", "");
        String[] stateManagerNames = clean.split(",");
        for (int i = 0; i < stateManagerNames.length; ++i) {
            this.stateManager.add(stateManagerNames[i]);
        }
    }

    public void setVariableResolver(String variableResolverName) {
        if (this.variableResolver == null) {
            this.variableResolver = new ArrayList<String>();
        }
        String clean = variableResolverName.replaceAll("[ \t\r\n]", "");
        String[] variableResolverNames = clean.split(",");
        for (int i = 0; i < variableResolverNames.length; ++i) {
            this.variableResolver.add(variableResolverNames[i]);
        }
    }

    public void setViewHandler(String viewHandlerName) {
        if (this.viewHandler == null) {
            this.viewHandler = new ArrayList<String>();
        }
        String[] viewHandlerNames = viewHandlerName.split(",^[ \t\r\n]+|[ \t\r\n]+$");
        for (int i = 0; i < viewHandlerNames.length; ++i) {
            this.viewHandler.add(viewHandlerNames[i]);
        }
    }

    private Locale toLocale(String localeString) {
        String country;
        String variant;
        String language;
        int separator;
        if (localeString == null || localeString.length() == 0) {
            Locale locale = Locale.getDefault();
            if (this.log.isWarnEnabled()) {
                this.log.warn("Locale name in faces-config.xml null or empty, setting locale to default locale : " + locale.toString(), new String[0]);
            }
            return locale;
        }
        int separatorCountry = localeString.indexOf(95);
        if (separatorCountry >= 0) {
            separator = 95;
        } else {
            separatorCountry = localeString.indexOf(45);
            separator = 45;
        }
        if (separatorCountry < 0) {
            language = localeString;
            variant = "";
            country = "";
        } else {
            language = localeString.substring(0, separatorCountry);
            int separatorVariant = localeString.indexOf(separator, separatorCountry + 1);
            if (separatorVariant < 0) {
                country = localeString.substring(separatorCountry + 1);
                variant = "";
            } else {
                country = localeString.substring(separatorCountry + 1, separatorVariant);
                variant = localeString.substring(separatorVariant + 1);
            }
        }
        return new Locale(language, country, variant);
    }
}

