/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2;

import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeTextProvider
implements TextProvider {
    private static final Log LOG = LogFactory.getLog(CompositeTextProvider.class);
    private List<TextProvider> textProviders = new ArrayList<TextProvider>();

    public CompositeTextProvider(List<TextProvider> textProviders) {
        this.textProviders.addAll(textProviders);
    }

    public CompositeTextProvider(TextProvider[] textProviders) {
        this(Arrays.asList(textProviders));
    }

    @Override
    public boolean hasKey(String key) {
        for (TextProvider tp : this.textProviders) {
            if (!tp.hasKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getText(String key) {
        return this.getText(key, key, Collections.<Object>emptyList());
    }

    @Override
    public String getText(String key, String defaultValue) {
        return this.getText(key, defaultValue, Collections.<Object>emptyList());
    }

    @Override
    public String getText(String key, String defaultValue, final String obj) {
        return this.getText(key, defaultValue, (List<Object>)new ArrayList<Object>(){
            {
                this.add(obj);
            }
        });
    }

    @Override
    public String getText(String key, List<Object> args) {
        return this.getText(key, key, args);
    }

    @Override
    public String getText(String key, String[] args) {
        return this.getText(key, key, args);
    }

    @Override
    public String getText(String key, String defaultValue, List<Object> args) {
        for (TextProvider textProvider : this.textProviders) {
            String msg = textProvider.getText(key, defaultValue, args);
            if (msg == null || msg.equals(defaultValue)) continue;
            return msg;
        }
        return defaultValue;
    }

    @Override
    public String getText(String key, String defaultValue, String[] args) {
        for (TextProvider textProvider : this.textProviders) {
            String msg = textProvider.getText(key, defaultValue, args);
            if (msg == null || msg.equals(defaultValue)) continue;
            return msg;
        }
        return defaultValue;
    }

    @Override
    public String getText(String key, String defaultValue, List<Object> args, ValueStack stack) {
        for (TextProvider textProvider : this.textProviders) {
            String msg = textProvider.getText(key, defaultValue, args, stack);
            if (msg == null || msg.equals(defaultValue)) continue;
            return msg;
        }
        return defaultValue;
    }

    @Override
    public String getText(String key, String defaultValue, String[] args, ValueStack stack) {
        for (TextProvider textProvider : this.textProviders) {
            String msg = textProvider.getText(key, defaultValue, args, stack);
            if (msg == null || msg.equals(defaultValue)) continue;
            return msg;
        }
        return defaultValue;
    }

    @Override
    public ResourceBundle getTexts(String bundleName) {
        for (TextProvider textProvider : this.textProviders) {
            ResourceBundle bundle = textProvider.getTexts(bundleName);
            if (bundle == null) continue;
            return bundle;
        }
        return null;
    }

    @Override
    public ResourceBundle getTexts() {
        for (TextProvider textProvider : this.textProviders) {
            ResourceBundle bundle = textProvider.getTexts();
            if (bundle == null) continue;
            return bundle;
        }
        return null;
    }
}

