/*
 * Decompiled with CFR 0.152.
 */
package heartbeat.landboom;

import heartbeat.Col;
import heartbeat.SingleTriRotator;
import heartbeat.Vec;

public class BloodRotator
extends SingleTriRotator {
    private static final int TRIANGLES = 800;
    private static final int FRAMES = 20;

    public BloodRotator(Vec pos, float radius) {
        super(800, 20);
        this.col = Col.make(70, 10, 20);
        float rad2 = radius * 2.0f;
        Vec flyPoint = new Vec(pos.x, pos.y - radius * 3.0f, pos.z);
        int left = 800;
        while (left-- > 0) {
            Vec dist;
            while ((dist = new Vec(radius - (float)Math.random() * rad2, radius - (float)Math.random() * rad2, radius - (float)Math.random() * rad2)).len() > radius) {
            }
            this.posList[left] = pos.add(dist);
            this.frameList[left] = (int)(Math.random() * 20.0);
            Vec dir = this.posList[left].sub(flyPoint);
            dir = dir.div(radius);
            dir.x *= 1.7f;
            dir.z *= 1.7f;
            this.dirList[left] = dir;
        }
        float fRad = 10.0f;
        left = 20;
        while (left-- > 0) {
            SingleTriRotator.Frame f = new SingleTriRotator.Frame();
            f.v1 = new Vec((float)(Math.random() * (double)fRad), (float)(Math.random() * (double)fRad), (float)(Math.random() * (double)fRad));
            f.v2 = new Vec((float)(Math.random() * (double)fRad), (float)(Math.random() * (double)fRad), (float)(Math.random() * (double)fRad));
            f.v3 = new Vec((float)(Math.random() * (double)fRad), (float)(Math.random() * (double)fRad), (float)(Math.random() * (double)fRad));
            this.frames[left] = f;
        }
    }

    public void update() {
        int left = 800;
        while (left-- > 0) {
            Vec pos = this.posList[left];
            Vec dir = this.dirList[left];
            dir.y -= 0.2f;
            dir.x = dir.x > 0.0f ? (dir.x -= 0.1f) : (dir.x += 0.1f);
            dir.z = dir.z > 0.0f ? (dir.z -= 0.1f) : (dir.z += 0.1f);
            float planeSpeed = (float)Math.sqrt(dir.x * dir.x + dir.z * dir.z);
            if (planeSpeed < 0.2f) {
                if (planeSpeed < 1.0E-5f) {
                    planeSpeed = 1.0E-4f;
                }
                dir.x /= planeSpeed;
                dir.z /= planeSpeed;
                dir.x /= -3.0f;
                dir.z /= -3.0f;
            }
            pos = pos.add(dir);
            if (pos.x < -200.0f) {
                pos.x = -200.0f;
                dir.x = Math.abs(dir.x);
            }
            if (pos.x > 200.0f) {
                pos.x = 200.0f;
                dir.x = -Math.abs(dir.x);
            }
            if (pos.z < -200.0f) {
                pos.z = -200.0f;
                dir.z = Math.abs(dir.z);
            }
            if (pos.z > 200.0f) {
                pos.z = 200.0f;
                dir.z = -Math.abs(dir.z);
            }
            if (pos.y < 0.0f) {
                float dist = (float)Math.sqrt(pos.x * pos.x + pos.z * pos.z) / 60.0f;
                if (dist > 1.0f) {
                    dist = 1.0f;
                }
                dist = 1.0f - dist;
                dist = dist * dist * dist;
                pos.y = 0.0f;
                dir.y = Math.abs(dir.y);
                dir.y = dir.y < 0.4f ? 1.0f + 8.0f * dist : (dir.y *= 0.7f);
            }
            this.posList[left] = pos;
            this.dirList[left] = dir;
        }
    }
}

