/*
 * Decompiled with CFR 0.152.
 */
package heartbeat;

public class Vec {
    public float x;
    public float y;
    public float z;
    public float u;
    public float v;
    public float u2;
    public float v2;

    public void normalize() {
        float len = this.len();
        if ((double)len > 1.0E-6) {
            this.x /= len;
            this.y /= len;
            this.z /= len;
        }
    }

    public float dot(Vec v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public Vec neg() {
        return new Vec(-this.x, -this.y, -this.z, this.u, this.v, this.u2, this.v2);
    }

    public Vec(float x, float y, float z, float u, float v, float u2, float v2) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.u = u;
        this.v = v;
        this.u2 = u2;
        this.v2 = v2;
    }

    public Vec(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.v = 0.0f;
        this.u = 0.0f;
        this.v2 = 0.0f;
        this.u2 = 0.0f;
    }

    public Vec(Vec v1, Vec v2) {
        this.x = v2.x - v1.x;
        this.y = v2.y - v1.y;
        this.z = v2.z - v1.z;
        this.u = v2.u - v1.u;
        this.v = v2.v - v1.v;
        this.u2 = v2.u2 - v1.u2;
        this.v2 = v2.v2 - v1.v2;
    }

    public Vec() {
        this(0.0f, 0.0f, 0.0f);
    }

    public float len() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public void setLen(float newLen) {
        this.normalize();
        this.x *= newLen;
        this.y *= newLen;
        this.z *= newLen;
    }

    public Vec add(Vec v) {
        return new Vec(this.x + v.x, this.y + v.y, this.z + v.z, this.u + v.u, this.v + v.v, this.u2 + v.u2, this.v2 + v.v2);
    }

    public Vec sub(Vec v) {
        return new Vec(this.x - v.x, this.y - v.y, this.z - v.z, this.u - v.u, this.v - v.v, this.u2 - v.u2, this.v2 - v.v2);
    }

    public Vec mul(float val) {
        return new Vec(this.x * val, this.y * val, this.z * val, this.u * val, this.v * val, this.u2 * val, this.v2 * val);
    }

    public Vec div(float val) {
        return new Vec(this.x / val, this.y / val, this.z / val, this.u / val, this.v / val, this.u2 / val, this.v2 / val);
    }

    public Vec cross(Vec v) {
        return new Vec(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
    }
}

