/*
 * Decompiled with CFR 0.152.
 */
package heartbeat;

import heartbeat.TimerListener;

public class Timer
extends Thread {
    protected TimerListener listener;
    protected int pause;
    protected boolean active;

    public Timer() {
        this((TimerListener)null);
    }

    public Timer(TimerListener listener) {
        this.listener = listener;
        this.pause = 1000;
        this.active = false;
    }

    public synchronized void setPause(int pause) {
        if (pause >= 0) {
            this.pause = pause;
        }
    }

    public synchronized void flipActive() {
        this.active = !this.active;
    }

    public synchronized void setListener(TimerListener listener) {
        this.listener = listener;
    }

    public void run() {
        try {
            while (true) {
                Thread.sleep(this.pause);
                if (!this.active || this.listener == null) continue;
                this.listener.timerEvent();
            }
        }
        catch (InterruptedException e) {
            this.interrupt();
            return;
        }
    }

    public synchronized boolean getActive() {
        return this.active;
    }

    public synchronized void setActive(boolean active) {
        this.active = active;
    }
}

