/*
 * Decompiled with CFR 0.152.
 */
package heartbeat;

import heartbeat.Col;
import heartbeat.PixelScreen;

public class Texture
extends PixelScreen {
    public static final int WIDTH = 256;
    public static final int HEIGHT = 256;

    public void makeBump(float strength) {
        int x;
        int[] data = this.getData();
        int[] xMove = new int[data.length];
        int[] yMove = new int[data.length];
        int idx = 0;
        int y = 0;
        while (y < this.height) {
            x = 0;
            while (x < this.width) {
                float xSlope = (this.getXSlope(x, y - 1) + this.getXSlope(x, y) + this.getXSlope(x, y + 1)) / 3.0f;
                float ySlope = (this.getYSlope(x - 1, y) + this.getYSlope(x, y) + this.getYSlope(x + 1, y)) / 3.0f;
                xMove[idx] = (int)(xSlope *= strength);
                yMove[idx] = (int)(ySlope *= strength);
                ++x;
                ++idx;
            }
            ++y;
        }
        idx = 0;
        y = 0;
        while (y < this.height) {
            x = 0;
            while (x < this.width) {
                int bumpVal;
                data[idx] = bumpVal = xMove[idx] + 127 << 8 | yMove[idx] + 127;
                ++x;
                ++idx;
            }
            ++y;
        }
    }

    public Texture() {
        super(256, 256);
    }

    private float getYSlope(int x, int y) {
        float h = this.getHeight(x, y);
        return (this.getHeight(x, y - 1) - h + (h - this.getHeight(x, y + 1))) / 2.0f;
    }

    private float getHeight(int x, int y) {
        int col = this.getPixel(x, y);
        return (float)(Col.getR(col) + Col.getG(col) + Col.getB(col)) / 3.0f;
    }

    private float getXSlope(int x, int y) {
        float h = this.getHeight(x, y);
        return (this.getHeight(x - 1, y) - h + (h - this.getHeight(x + 1, y))) / 2.0f;
    }
}

