/*
 * Decompiled with CFR 0.152.
 */
package heartbeat;

import heartbeat.Effect;
import heartbeat.HeartSound;
import heartbeat.PixelScreen;
import heartbeat.TextScreen;
import heartbeat.TimerListener;
import heartbeat.blurrer.WeirdEffect;
import heartbeat.landboom.CustomEffect;
import heartbeat.pauser.Pauser;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.image.MemoryImageSource;

public class Runner
extends Panel
implements TimerListener {
    private PixelScreen myScreen = new PixelScreen(400, 250);
    private HeartSound mySound;
    private Image myBuffer;
    private MemoryImageSource myImageSource;
    private int myRunningCountdown;
    private boolean running;
    private int myEffectNum;
    private Effect[] myEffectList;
    private Effect myEffect;

    private void setEffect(Effect effect) {
        if (this.myEffect != null) {
            Effect e = this.myEffect;
            this.myEffect = null;
            e.deInit();
        }
        if (effect != null) {
            try {
                effect.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.myEffect = effect;
        }
    }

    private void nextEffect() {
        switch (++this.myEffectNum) {
            default: {
                this.myEffectNum = 0;
                this.setupEffects();
                this.mySound.setSoundEnabled(true);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
        this.setEffect(this.myEffectList[this.myEffectNum]);
    }

    public Runner(HeartSound sound) {
        this.mySound = sound;
        this.myImageSource = new MemoryImageSource(this.myScreen.width, this.myScreen.height, this.myScreen.getData(), 0, this.myScreen.width);
        this.myImageSource.setAnimated(true);
        this.myBuffer = this.createImage(this.myImageSource);
        this.myEffectList = new Effect[3];
        this.myEffectNum = -1;
        this.myRunningCountdown = 5;
        this.running = false;
    }

    public void paint(Graphics g) {
        if (!this.running) {
            if (TextScreen.image == null && this.myRunningCountdown <= 2) {
                TextScreen.image = this.createImage(400, 250);
            }
            int n = this.myRunningCountdown;
            this.myRunningCountdown = n + -1;
            if (n <= 0) {
                this.nextEffect();
                this.running = true;
            }
        }
        if (this.myEffect != null) {
            this.myEffect.render();
        }
        this.myImageSource.newPixels();
        g.drawImage(this.myBuffer, 0, 0, null);
    }

    public void timerEvent() {
        try {
            if (this.running && this.myEffect != null) {
                this.myEffect.run();
            }
        }
        catch (Effect.EffectEnding e) {
            this.nextEffect();
        }
        this.repaint();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    private void setupEffects() {
        this.myEffectList[0] = new Pauser(10);
        this.myEffectList[1] = new WeirdEffect();
        this.myEffectList[2] = new CustomEffect();
        int i = 0;
        while (i < this.myEffectList.length) {
            this.myEffectList[i].setInfo(this, this.myScreen, this.mySound);
            this.myEffectList[i].init();
            ++i;
        }
    }
}

