/*
 * Decompiled with CFR 0.152.
 */
package heartbeat;

import heartbeat.Texture;
import heartbeat.Tri;
import heartbeat.Vec;

public class Mesh {
    public Tri[] triList;
    public Vec[] vecList;
    public Vec[] normalList;

    public Mesh(int vecSize, int triSize) {
        this.triList = new Tri[triSize];
        this.vecList = new Vec[vecSize];
    }

    public Mesh() {
        this(0, 0);
    }

    public void setColor(int color) {
        int size = this.triList.length;
        int i = 0;
        while (i < size) {
            this.triList[i].col = color;
            ++i;
        }
    }

    public void prepare() {
        this.normalList = new Vec[this.vecList.length];
        int[] normalCount = new int[this.vecList.length];
        int size = this.triList.length;
        int i = 0;
        while (i < size) {
            Tri t = this.triList[i];
            Vec v1 = this.vecList[t.v1];
            Vec v2 = this.vecList[t.v2];
            Vec v3 = this.vecList[t.v3];
            Vec l1 = v2.sub(v1);
            Vec l2 = v3.sub(v1);
            l1.normalize();
            l2.normalize();
            Vec normal = l1.cross(l2);
            normal.normalize();
            t.normal = normal;
            this.addToNormal(t.v1, normal);
            int n = t.v1;
            normalCount[n] = normalCount[n] + 1;
            this.addToNormal(t.v2, normal);
            int n2 = t.v2;
            normalCount[n2] = normalCount[n2] + 1;
            this.addToNormal(t.v3, normal);
            int n3 = t.v3;
            normalCount[n3] = normalCount[n3] + 1;
            ++i;
        }
        size = this.normalList.length;
        i = 0;
        while (i < size) {
            this.normalList[i] = normalCount[i] > 0 ? this.normalList[i].div(normalCount[i]) : new Vec();
            ++i;
        }
    }

    public void setBumpTexture(Texture tex) {
        int size = this.triList.length;
        int i = 0;
        while (i < size) {
            this.triList[i].bump = tex;
            ++i;
        }
    }

    private void addToNormal(int idx, Vec normalToAdd) {
        if (this.normalList[idx] == null) {
            this.normalList[idx] = new Vec();
        }
        this.normalList[idx] = this.normalList[idx].add(normalToAdd);
    }

    public void setTexture(Texture tex) {
        int size = this.triList.length;
        int i = 0;
        while (i < size) {
            this.triList[i].texture = tex;
            ++i;
        }
    }
}

