/*
 * Decompiled with CFR 0.152.
 */
package me.petterroea.bday2012;

import java.util.LinkedList;
import java.util.Random;
import me.petterroea.bday2012.Particle;

public class Emitter {
    int x;
    int y;
    double xspeed;
    double yspeed;
    double gravity;
    int motorLife;
    int life;
    long startStamp;
    boolean dead = false;
    long lastParticle;

    public Emitter(int x, int y, double xspeed, double yspeed, int motorLife, int life, double gravity) {
        this.x = x;
        this.y = y;
        this.xspeed = xspeed;
        this.yspeed = yspeed;
        this.motorLife = motorLife;
        this.life = life;
        this.gravity = gravity;
        this.startStamp = System.currentTimeMillis();
        this.lastParticle = System.currentTimeMillis();
    }

    public void update(int delta, LinkedList<Particle> particles) {
        Random random = new Random();
        if (this.dead || System.currentTimeMillis() - this.startStamp > (long)this.life) {
            this.dead = true;
            int r = random.nextInt(100) + 100;
            int g = random.nextInt(100) + 100;
            int b = random.nextInt(100) + 100;
            int i = 0;
            while (i < 500) {
                double newx = Math.sin(i) * (double)(random.nextInt(40) + 20) + (double)this.x;
                double newy = Math.cos(i) * (double)(random.nextInt(40) + 20) + (double)this.y;
                particles.add(new Particle((int)newx, (int)newy, Math.sin(i) / 3.0, Math.cos(i) / 3.0, 100, random.nextInt(700) + 200, 0.001, random.nextInt(10) + r, random.nextInt(10) + g, random.nextInt(10) + b, 1));
                ++i;
            }
            return;
        }
        if (System.currentTimeMillis() - this.startStamp > (long)this.motorLife) {
            this.yspeed -= this.gravity * (double)delta;
        }
        this.x = (int)((double)this.x - this.xspeed * (double)delta / 10.0);
        this.y = (int)((double)this.y - this.yspeed * (double)delta / 10.0);
        if (System.currentTimeMillis() - this.lastParticle > 10L) {
            this.lastParticle = System.currentTimeMillis();
            int life = random.nextInt(500) + 500;
            particles.add(new Particle(this.x + (random.nextInt(20) - 10), this.y, 0.0, random.nextInt(2) + 3, life, life, 0.01, random.nextInt(30) + 200, random.nextInt(30) + 200, random.nextInt(30) + 200, random.nextInt(2)));
        }
    }
}

