/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SpiderEditor
extends JFrame {
    private static final int WIDTH = 800;
    private static final int HEIGHT = 600;
    private static final int FRAME_TIME = 16;
    private boolean running;
    private boolean[] keys = new boolean[1024];
    private boolean quality = true;
    private ArrayList<Point2D.Double> points = new ArrayList();
    private ArrayList<Point2D.Double> objects = new ArrayList();
    private Point2D.Double start;
    private Point2D.Double goal;
    private int mouseX = 0;
    private int mouseY = 0;
    private int mouseClicked = 0;
    private Point2D.Double held = null;
    private Point2D.Double selected = null;
    int ileft;
    int itop;

    public static void main(String[] stringArray) {
        new SpiderEditor();
    }

    public SpiderEditor() {
        this.setSize(new Dimension(800 + this.getInsets().right * this.getInsets().left, 600 + this.getInsets().top + this.getInsets().bottom));
        this.setLocation(100, 100);
        this.setResizable(false);
        this.setTitle("SpiderEditor");
        this.enableEvents(511L);
        this.setVisible(true);
        while (true) {
            this.ileft = this.getInsets().left;
            this.itop = this.getInsets().top;
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            Image image = this.createImage(800, 600);
            Graphics2D graphics2D2 = (Graphics2D)image.getGraphics();
            this.running = true;
            long l = System.currentTimeMillis();
            float f = 10000.0f;
            float f2 = 16.0f;
            int n = 0;
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            while (this.running) {
                Point2D.Double double_2;
                int n2;
                ++n;
                graphics2D2.setColor(Color.white);
                graphics2D2.fillRect(0, 0, 800, 600);
                for (n2 = 0; n2 < 800; n2 += 266) {
                    graphics2D2.setColor(Color.gray.brighter());
                    graphics2D2.drawLine(n2, 0, n2, 600);
                }
                for (n2 = 0; n2 < 600; n2 += 200) {
                    graphics2D2.setColor(Color.gray.brighter());
                    graphics2D2.drawLine(0, n2, 800, n2);
                }
                graphics2D2.setColor(Color.gray.brighter());
                graphics2D2.drawString("Click mouse 1 to add node.", 543, 416);
                graphics2D2.drawString("A to add object.", 543, 432);
                graphics2D2.drawString("Hold mouse 1 to move node or object.", 543, 448);
                graphics2D2.drawString("Click mouse 2 to remove node or object.", 543, 464);
                graphics2D2.drawString("Q to add or move start.", 543, 480);
                graphics2D2.drawString("W to add or move goal.", 543, 496);
                graphics2D2.drawString("S to save map.", 543, 512);
                graphics2D2.drawString("L to load map.", 543, 528);
                graphics2D2.drawString("Each square is one screen in game.", 543, 544);
                for (Point2D.Double double_2 : this.points) {
                    if (double_2 != this.selected) {
                        graphics2D2.setColor(new Color(150, 150, 150, 150));
                        graphics2D2.fillOval((int)double_2.x - 6, (int)double_2.y - 6, 12, 12);
                        continue;
                    }
                    graphics2D2.setColor(new Color(255, 120, 120, 150));
                    graphics2D2.fillOval((int)double_2.x - 6, (int)double_2.y - 6, 12, 12);
                }
                for (int i = 0; i < this.points.size() - 1; ++i) {
                    double_2 = this.points.get(i);
                    Point2D.Double double_3 = this.points.get(i + 1);
                    graphics2D2.setColor(Color.black);
                    graphics2D2.drawLine((int)double_2.x, (int)double_2.y, (int)double_3.x, (int)double_3.y);
                    double d = Math.atan2(double_2.y - double_3.y, double_2.x - double_3.x);
                    double d2 = double_3.x + 10.0 * Math.cos(d + 0.5235987755982988);
                    double d3 = double_3.y + 10.0 * Math.sin(d + 0.5235987755982988);
                    double d4 = double_3.x + 10.0 * Math.cos(d - 0.5235987755982988);
                    double d5 = double_3.y + 10.0 * Math.sin(d - 0.5235987755982988);
                    graphics2D2.drawLine((int)double_3.x, (int)double_3.y, (int)d2, (int)d3);
                    graphics2D2.drawLine((int)double_3.x, (int)double_3.y, (int)d4, (int)d5);
                }
                if (this.points.size() > 1) {
                    Point2D.Double double_4 = this.points.get(0);
                    double_2 = this.points.get(this.points.size() - 1);
                    double d = Math.atan2(double_2.y - double_4.y, double_2.x - double_4.x);
                    double d6 = double_4.x + 10.0 * Math.cos(d + 0.5235987755982988);
                    double d7 = double_4.y + 10.0 * Math.sin(d + 0.5235987755982988);
                    double d8 = double_4.x + 10.0 * Math.cos(d - 0.5235987755982988);
                    double d9 = double_4.y + 10.0 * Math.sin(d - 0.5235987755982988);
                    graphics2D2.drawLine((int)double_4.x, (int)double_4.y, (int)d6, (int)d7);
                    graphics2D2.drawLine((int)double_4.x, (int)double_4.y, (int)d8, (int)d9);
                    graphics2D2.setColor(Color.black);
                    graphics2D2.drawLine((int)double_2.x, (int)double_2.y, (int)double_4.x, (int)double_4.y);
                }
                for (Point2D.Double double_2 : this.objects) {
                    graphics2D2.setColor(new Color(80, 120, 255, 150));
                    graphics2D2.fillOval((int)double_2.x - 6, (int)double_2.y - 6, 12, 12);
                }
                if (this.goal != null) {
                    graphics2D2.setColor(new Color(255, 150, 0, 255));
                    graphics2D2.drawOval((int)this.goal.x - 6, (int)this.goal.y - 6, 12, 12);
                    graphics2D2.drawOval((int)this.goal.x - 4, (int)this.goal.y - 4, 8, 8);
                    graphics2D2.drawString("goal", (int)this.goal.x - 12, (int)this.goal.y + 18);
                }
                if (this.start != null) {
                    graphics2D2.setColor(new Color(50, 200, 0, 255));
                    graphics2D2.drawOval((int)this.start.x - 6, (int)this.start.y - 6, 12, 12);
                    graphics2D2.drawOval((int)this.start.x - 4, (int)this.start.y - 4, 8, 8);
                    graphics2D2.drawString("start", (int)this.start.x - 12, (int)this.start.y + 18);
                }
                if (this.held != null) {
                    this.held.setLocation(this.mouseX, this.mouseY);
                }
                if (this.mouseClicked != 0) {
                    for (Point2D.Double double_2 : this.points) {
                        double d = Math.sqrt(Math.pow(double_2.x - (double)this.mouseX, 2.0) + Math.pow(double_2.y - (double)this.mouseY, 2.0));
                        if (!(d <= 6.0)) continue;
                        this.held = double_2;
                        if (this.mouseClicked != 1) continue;
                        this.selected = double_2;
                    }
                    for (Point2D.Double double_2 : this.objects) {
                        double d = Math.sqrt(Math.pow(double_2.x - (double)this.mouseX, 2.0) + Math.pow(double_2.y - (double)this.mouseY, 2.0));
                        if (!(d <= 6.0)) continue;
                        this.held = double_2;
                    }
                    if (this.mouseClicked == 1 && this.held == null) {
                        Object object;
                        if (this.selected != null) {
                            object = new Point2D.Double(this.mouseX, this.mouseY);
                            this.points.add(this.points.indexOf(this.selected) + 1, (Point2D.Double)object);
                            this.selected = object;
                            this.held = object;
                        } else {
                            object = new Point2D.Double(this.mouseX, this.mouseY);
                            this.points.add((Point2D.Double)object);
                            this.selected = object;
                            this.held = object;
                        }
                    }
                    if (this.mouseClicked == 3 && this.held != null) {
                        if (this.points.contains(this.held)) {
                            if (this.points.size() > 0) {
                                int n3 = 0;
                                if (this.points.indexOf(this.held) != 0) {
                                    n3 = this.points.indexOf(this.held) - 1;
                                } else if (this.points.size() > 1 && this.points.indexOf(this.held) == 0) {
                                    n3 = this.points.size() - 1;
                                }
                                this.selected = this.points.get(n3);
                            }
                            this.points.remove(this.held);
                        } else {
                            this.objects.remove(this.held);
                        }
                    }
                    this.mouseClicked = 0;
                }
                if (this.keys[65]) {
                    if (this.held == null) {
                        Point2D.Double double_5 = new Point2D.Double(this.mouseX, this.mouseY);
                        this.objects.add(double_5);
                    }
                    this.keys[65] = false;
                }
                if (this.keys[81]) {
                    this.start = new Point2D.Double(this.mouseX, this.mouseY);
                }
                if (this.keys[87]) {
                    this.goal = new Point2D.Double(this.mouseX, this.mouseY);
                }
                if (this.keys[83]) {
                    this.keys[83] = false;
                    if (this.goal != null && this.start != null) {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (Point2D.Double double_6 : this.points) {
                            int n4 = (int)(double_6.x * 3.0 / 16.0);
                            int n5 = (int)(double_6.y * 3.0 / 16.0);
                            String string = Integer.toHexString(n4);
                            String string2 = Integer.toHexString(n5);
                            if (string.length() == 1) {
                                string = "0" + string;
                            }
                            if (string2.length() == 1) {
                                string2 = "0" + string2;
                            }
                            stringBuilder.append(string);
                            stringBuilder.append(string2);
                        }
                        int n6 = (int)(this.start.x * 3.0 / 16.0);
                        int n7 = (int)(this.start.y * 3.0 / 16.0);
                        String string = Integer.toHexString(n6);
                        String string3 = Integer.toHexString(n7);
                        if (string.length() == 1) {
                            string = "0" + string;
                        }
                        if (string3.length() == 1) {
                            string3 = "0" + string3;
                        }
                        stringBuilder.append(string);
                        stringBuilder.append(string3);
                        n6 = (int)(this.goal.x * 3.0 / 16.0);
                        n7 = (int)(this.goal.y * 3.0 / 16.0);
                        string = Integer.toHexString(n6);
                        string3 = Integer.toHexString(n7);
                        if (string.length() == 1) {
                            string = "0" + string;
                        }
                        if (string3.length() == 1) {
                            string3 = "0" + string3;
                        }
                        stringBuilder.append(string);
                        stringBuilder.append(string3);
                        StringBuilder stringBuilder2 = new StringBuilder();
                        for (Point2D.Double double_7 : this.objects) {
                            n6 = (int)(double_7.x * 3.0 / 16.0);
                            n7 = (int)(double_7.y * 3.0 / 16.0);
                            string = Integer.toHexString(n6);
                            string3 = Integer.toHexString(n7);
                            if (string.length() == 1) {
                                string = "0" + string;
                            }
                            if (string3.length() == 1) {
                                string3 = "0" + string3;
                            }
                            stringBuilder2.append(string);
                            stringBuilder2.append(string3);
                        }
                        JOptionPane.showInputDialog("Save map. Format is STATICTERRAIN,MOVEABLES.", (Object)(stringBuilder.toString() + "," + stringBuilder2.toString()));
                    } else {
                        JOptionPane.showMessageDialog(this, "You need to place both start and goal!");
                    }
                }
                if (this.keys[76]) {
                    String string = JOptionPane.showInputDialog("Load map. Format is STATICTERRAIN,MOVEABLES.", (Object)"");
                    if (string != null) {
                        String[] stringArray = string.split(",");
                        if (stringArray.length >= 1) {
                            if (stringArray[0].length() % 4 == 0) {
                                ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
                                ArrayList<Point2D.Double> arrayList2 = new ArrayList<Point2D.Double>();
                                Point2D.Double double_8 = new Point2D.Double(400.0, 280.0);
                                Point2D.Double double_9 = new Point2D.Double(400.0, 320.0);
                                try {
                                    if (stringArray.length > 1) {
                                        if (stringArray[1].length() % 4 == 0) {
                                            for (int i = 0; i < stringArray[1].length() / 4; ++i) {
                                                arrayList2.add(new Point2D.Double((double)Integer.parseInt(stringArray[1].substring(i * 4, i * 4 + 2), 16) * 16.0 / 3.0, (double)Integer.parseInt(stringArray[1].substring(i * 4 + 2, i * 4 + 4), 16) * 16.0 / 3.0));
                                            }
                                        } else {
                                            JOptionPane.showMessageDialog(this, "Failed to load objects (input must be divisible by four).");
                                        }
                                    }
                                    int n8 = 0;
                                    for (n8 = 0; n8 < stringArray[0].length() / 4 - 2; ++n8) {
                                        arrayList.add(new Point2D.Double((double)Integer.parseInt(stringArray[0].substring(n8 * 4, n8 * 4 + 2), 16) * 16.0 / 3.0, (double)Integer.parseInt(stringArray[0].substring(n8 * 4 + 2, n8 * 4 + 4), 16) * 16.0 / 3.0));
                                    }
                                    double_8 = new Point2D.Double((double)Integer.parseInt(stringArray[0].substring(n8 * 4, n8 * 4 + 2), 16) * 16.0 / 3.0, (double)Integer.parseInt(stringArray[0].substring(n8 * 4 + 2, n8 * 4 + 4), 16) * 16.0 / 3.0);
                                    double_9 = new Point2D.Double((double)Integer.parseInt(stringArray[0].substring(++n8 * 4, n8 * 4 + 2), 16) * 16.0 / 3.0, (double)Integer.parseInt(stringArray[0].substring(n8 * 4 + 2, n8 * 4 + 4), 16) * 16.0 / 3.0);
                                }
                                catch (Exception exception) {
                                    JOptionPane.showMessageDialog(this, "Failed to load map.");
                                }
                                this.points = arrayList;
                                this.objects = arrayList2;
                                this.start = double_8;
                                this.goal = double_9;
                            } else {
                                JOptionPane.showMessageDialog(this, "Incorrect input (must be divisible by four)!");
                            }
                        } else {
                            JOptionPane.showMessageDialog(this, "Please use the format STATICTERRAIN,MOVEABLES (include ',' even if there are no moveables).");
                        }
                    }
                    this.keys[76] = false;
                }
                if (this.keys[82]) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.running = false;
                }
                if (this.keys[27]) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.exit(0);
                }
                graphics2D.drawImage(image, this.ileft, this.itop, null);
                long l2 = System.currentTimeMillis();
                f2 = (f2 * 20.0f + (float)(l2 - l)) / 21.0f;
                l = l2;
                f += f * (16.0f / f2 - 1.0f) * 0.1f + 0.05f;
                int n9 = 0;
                while ((float)n9 < f) {
                    Thread.yield();
                    ++n9;
                }
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
            }
        }
    }

    public void processEvent(AWTEvent aWTEvent) {
        switch (aWTEvent.getID()) {
            case 201: {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(0);
                break;
            }
            case 401: {
                this.keys[((KeyEvent)aWTEvent).getKeyCode()] = true;
                int n = ((KeyEvent)aWTEvent).getKeyCode();
                if (n != 81) break;
                this.quality = !this.quality;
                break;
            }
            case 402: {
                this.keys[((KeyEvent)aWTEvent).getKeyCode()] = false;
                break;
            }
            case 501: {
                this.mouseX = ((MouseEvent)aWTEvent).getX() - this.ileft;
                this.mouseY = ((MouseEvent)aWTEvent).getY() - this.itop;
                this.mouseClicked = ((MouseEvent)aWTEvent).getButton();
                break;
            }
            case 502: {
                this.held = null;
                break;
            }
            case 506: {
                this.mouseX = ((MouseEvent)aWTEvent).getX() - this.ileft;
                this.mouseY = ((MouseEvent)aWTEvent).getY() - this.itop;
                break;
            }
            case 503: {
                this.mouseX = ((MouseEvent)aWTEvent).getX() - this.ileft;
                this.mouseY = ((MouseEvent)aWTEvent).getY() - this.itop;
            }
        }
    }
}

