
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferStrategy;

import javax.swing.JFrame;

/*
 * Created on 25/01/2005
 */

public class S extends JFrame {

    private static final Color[] PIECE_COLORS = { Color.blue, Color.green,
            Color.red, Color.yellow, Color.pink, Color.magenta };

    private int[] pieces;

    private int[] pinTip;

    private int[] secret;

    private int currentRow;

    private int selectedPiece;

    private boolean started;

    private boolean gameOver;

    private boolean win;

    private S() {
        super("Secret Colors");
        super.setSize(175, 600);
        super.setResizable(false);
        super.show();
        super.createBufferStrategy(2);
        // Enable mouse events.
        super.enableEvents(16);
        BufferStrategy strategy = getBufferStrategy();
        this.init();
        while (true) {
            if (this.currentRow <= 9) {
                this.logic();
                this.render(strategy.getDrawGraphics());
                strategy.show();
            }
        }
    }

    private void init() {
        this.pieces = new int[10 * 4];
        this.pinTip = new int[10 * 4];
        this.secret = new int[4];
        this.selectedPiece = -1;
        this.started = false;
        this.gameOver = false;
        this.emptyBoard();
    }

    private void emptyBoard() {
        for (int i = 0; i < this.pieces.length; i++) {
            this.pieces[i] = -1;
            this.pinTip[i] = -1;
        }
        for (int i = 0; i < 4; i++) {
            this.secret[i] = -1;
            while (this.secret[i] < 0) {
                int k = (int) (Math.random() * 6);
                this.secret[i] = k;
            }
        }
        this.currentRow = 0;
    }

    private void logic() {
        boolean temp = true;

        for (int j = 0; j < 4; j++) {
            temp = (temp && (this.pieces[currentRow * 4 + j] >= 0));
        }

        if (temp) {
            int[] currentGuess = new int[4];
            for (int j = 0; j < 4; j++) {
                currentGuess[j] = this.pieces[currentRow * 4 + j];
            }

            int totalRight = 0;
            int aux = 0;
            for (int i = 0; i < 4; i++) {
                for (int j = 0; j < 4; j++) {
                    if (currentGuess[j] == secret[i]) {
                        pinTip[currentRow * 4 + aux++] = 0;
                        currentGuess[j] = -1;
                        break;
                    }
                }
            }
            aux = 0;
            for (int j = 0; j < 4; j++) {
                if (pieces[currentRow * 4 + j] == secret[j]) {
                    totalRight++;
                    pinTip[currentRow * 4 + aux++] = 1;
                }
            }

            if (totalRight == 4) {
                this.win = true;
                this.gameOver = true;
            }
            currentRow++;
            if (currentRow > 9) {
                if (totalRight < 4) {
                    this.win = false;
                    this.gameOver = true;
                }
            }
        }

    }

    private void drawPiece(Graphics g, int x, int y, Color c) {
        g.setColor(Color.black);
        g.fillOval(x + 2, y + 2, 18, 18);

        g.setColor(c);
        g.fillOval(x, y, 18, 18);

        g.setColor(c.darker());
        g.fillOval(x + 1, y + 1, 15, 15);

        g.setColor(Color.white);
        g.fillOval(x + 5, y + 5, 3, 3);

    }

    private void render(Graphics g) {
        // Clear screen.
        g.setColor(Color.black);
        g.fillRect(0, 0, 175, 600);

        if (!started) {
            g.setFont(g.getFont().deriveFont(Font.BOLD, 20.0f));
            g.setColor(Color.red);
            g.drawString("Secret Colors", 17, 250);
            g.drawString("4k Game", 34, 270);
            g.setColor(Color.white);
            g.drawString("Press Space", 21, 350);
            return;
        }
        g.setFont(g.getFont().deriveFont(Font.BOLD, 16.0f));
        g.setColor(Color.green);
        g.drawString("Reveal", 20, 540);
        g.setColor(Color.red);
        g.drawString("Restart", 100, 540);

        // Draw secret.
        g.setColor(Color.gray);
        g.fill3DRect(13, 50, 150, 35, true);
        g.fill3DRect(13, 90, 150, 370, true);

        g.setColor(Color.blue);
        for (int i = 0; i < 10; i++) {
            if (i == 9 - this.currentRow) {
                g.setColor(Color.red);

            } else {
                g.setColor(Color.blue);
            }
            g.drawRoundRect(20, (100 + i * 35), 100, 30, 10, 10);
            g.drawRoundRect(125, (100 + i * 35), 30, 30, 10, 10);

            // Draw pieces in the board.
            for (int k = 0; k < 4; k++) {
                if (this.pieces[(9 - i) * 4 + k] == -1) {
                    g.setColor(Color.black);
                    g.fillOval(28 + k * 24, (110 + i * 35), 13, 13);
                    g.setColor(Color.lightGray);
                    g.drawArc(31 + k * 24, 113 + i * 35, 10, 10, -145, 190);
                } else {
                    this.drawPiece(g, 26 + k * 24, 108 + i * 35,
                            PIECE_COLORS[this.pieces[(9 - i) * 4 + k]]);
                }
            }

            // Draw tips.
            int pin = 0;
            for (int k = 0; k < 2; k++) {
                for (int j = 0; j < 2; j++) {
                    if (this.pinTip[(9 - i) * 4 + pin] != -1) {
                        if (this.pinTip[(9 - i) * 4 + pin] == 0) {
                            g.setColor(Color.darkGray);
                            g.fillOval(132 + k * 10, (107 + i * 35) + j * 10,
                                    9, 9);
                            g.setColor(Color.white);
                            g.fillOval(130 + k * 10, (105 + i * 35) + j * 10,
                                    9, 9);
                        } else {
                            g.setColor(Color.darkGray);
                            g.fillOval(132 + k * 10, (107 + i * 35) + j * 10,
                                    9, 9);
                            g.setColor(Color.black);
                            g.fillOval(130 + k * 10, (105 + i * 35) + j * 10,
                                    9, 9);
                            g.setColor(Color.white);
                            g.drawArc(130 + k * 10, (105 + i * 35) + j * 10, 9,
                                    9, 70, 130);

                        }

                    } else {
                        g.setColor(Color.black);
                        g.fillOval(132 + k * 10, (107 + i * 35) + j * 10, 7, 7);
                        g.setColor(Color.lightGray);
                        g.drawArc(135 + k * 10, (110 + i * 35) + j * 10, 4, 4,
                                -145, 190);

                    }
                    pin++;
                }
            }
        }

        // Draw avaiable colors
        g.setColor(Color.gray);
        g.fill3DRect(13, 470, 150, 50, true);
        g.setFont(g.getFont().deriveFont(Font.BOLD, 12.0f));
        g.setColor(Color.BLACK);
        g.drawString("Pick up a piece", 50, 485);
        for (int i = 0, j = 15; i < PIECE_COLORS.length; i++, j += 25) {
            this.drawPiece(g, j, 490, PIECE_COLORS[i]);
            if (i == this.selectedPiece) {
                g.setColor(Color.white);
                g.fill3DRect(j, 512, 20, 3, true);
            }
        }

        if (this.gameOver) {
            for (int k = 0; k < 4; k++) {
                this
                        .drawPiece(g, 28 + k * 24, 60,
                                PIECE_COLORS[this.secret[k]]);
            }
            g.setFont(g.getFont().deriveFont(Font.BOLD, 20.0f));
            if (this.win) {
                g.drawString("YOU WIN!", 30, 570);
            } else {
                g.drawString("GAME OVER!", 25, 570);

            }
        }

    }

    protected void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            System.exit(0);
        } else if (e.getKeyCode() == 32) {
            started = true;
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.awt.Component#processMouseEvent(java.awt.event.MouseEvent)
     */
    protected void processMouseEvent(MouseEvent e) {
        if (e.getButton() == MouseEvent.BUTTON1) {
            if (e.getY() > 525 && e.getY() < 540) {
                if (e.getX() > 20 && e.getX() < 70) {
                    this.gameOver = true;
                    this.win = false;
                } else if (e.getX() > 100 && e.getX() < 160) {
                    this.init();
                }
            }

            if (this.gameOver || this.win) {
                return;
            }

            if ((e.getY() > 490) && (e.getY() < 510)) {
                int[] pieces = { 15, 40, 65, 90, 115, 140 };
                for (int i = 0; i < pieces.length; i++) {
                    if ((e.getX() > pieces[i]) && (e.getX() < pieces[i] + 20)) {
                        this.selectedPiece = i;
                    }
                }
            }
            if ((e.getY() > 100) && (e.getY() < 480)) {
                int[] rows = { 420, 385, 350, 315, 280, 245, 210, 175, 140, 105 };
                int[] cols = { 30, 55, 80, 100 };

                if (e.getY() > rows[this.currentRow]
                        && e.getY() < rows[this.currentRow] + 20) {

                    for (int i = 0; i < cols.length; i++) {
                        if ((e.getX() > cols[i]) && (e.getX() < cols[i] + 10)) {
                            this.pieces[this.currentRow * 4 + i] = this.selectedPiece;
                        }

                    }
                }
            }
        }
    }

    public static void main(String[] args) {
        new S();
    }
}