/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class RoundWorld
extends JComponent
implements KeyListener,
Runnable {
    private double[] badRs = new double[10];
    private double[] badTs = new double[10];
    private double[] badVts = new double[10];
    private boolean[] dudeGroundeds = new boolean[4];
    private double[] dudeLives = new double[]{2.0, 2.0, 2.0, 2.0};
    private double[] dudeRs = new double[4];
    private double[] dudeTs = new double[4];
    private double[] dudeVrs = new double[4];
    private boolean[] keys = new boolean[256];
    private BufferedImage sky;
    private boolean rough;
    private int started;
    private int points;

    public static void main(String[] stringArray) throws Throwable {
        SwingUtilities.invokeAndWait(new RoundWorld());
    }

    private boolean alive(int n) {
        return this.dudeLives[n] > 0.0 && this.dudeLives[n] <= 1.0;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n < this.keys.length) {
            this.keys[n] = true;
            if (n == 32) {
                this.rough = !this.rough;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n < this.keys.length) {
            this.keys[n] = false;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void paintComponent(Graphics graphics) {
        int n;
        int[] nArray;
        int[] nArray2;
        Object[] objectArray;
        Object object;
        double[] dArray;
        boolean[] blArray;
        double[] dArray2;
        block48: {
            double d;
            int n2;
            block47: {
                this.repaint(50L);
                dArray2 = new double[4];
                blArray = new boolean[10];
                dArray = new double[4];
                if (this.started >= 0) break block47;
                if (this.keys[27]) {
                    this.started = 0;
                    this.points = 0;
                    Arrays.fill(this.badRs, 0.0);
                    Arrays.fill(this.badVts, 0.0);
                    Arrays.fill(this.dudeGroundeds, false);
                    Arrays.fill(this.dudeLives, 2.0);
                    Arrays.fill(this.dudeVrs, 0.0);
                }
                break block48;
            }
            object = new int[]{83, 75, 40, 101};
            objectArray = new int[]{65, 74, 37, 100};
            nArray2 = new int[]{68, 76, 39, 102};
            nArray = new int[]{87, 73, 38, 104};
            this.started *= -1;
            n = 0;
            while (n < this.dudeRs.length) {
                n2 = this.keys[object[n]];
                boolean bl = this.keys[objectArray[n]];
                boolean bl2 = this.keys[nArray2[n]];
                boolean bl3 = this.keys[nArray[n]];
                double d2 = this.dudeRs[n];
                double d3 = this.dudeTs[n];
                if (this.dudeLives[n] > 1.0 && (bl || bl2 || bl3)) {
                    this.dudeLives[n] = 1.0;
                    d2 = 370.0;
                    d3 = 1.5707963267948966 * ((double)n + 0.5);
                }
                if (this.alive(n)) {
                    this.started = 1;
                    d = 0.15;
                    if (bl3) {
                        d *= 0.4;
                        if (this.dudeGroundeds[n]) {
                            int n3 = n;
                            this.dudeVrs[n3] = this.dudeVrs[n3] + 4.0;
                        }
                    }
                    if (n2 != 0) {
                        d *= 3.0;
                    }
                    int n4 = n;
                    this.dudeVrs[n4] = this.dudeVrs[n4] - d;
                    double d4 = 0.0;
                    if (!this.dudeGroundeds[n]) {
                        if (bl) {
                            d4 = 2.0;
                        }
                        if (bl2) {
                            d4 = -2.0;
                        }
                    }
                    d3 += (double)((d3 += d4 / (d2 += this.dudeVrs[n])) > Math.PI ? -2 : (d3 < -Math.PI ? 2 : 0)) * Math.PI;
                    this.dudeGroundeds[n] = false;
                    if (d2 < 80.0) {
                        d2 = 80.0;
                        dArray[n] = 0.0;
                        this.dudeVrs[n] = 0.0;
                        this.dudeGroundeds[n] = true;
                    }
                    this.dudeRs[n] = d2;
                    this.dudeTs[n] = d3;
                    dArray[n] = d4;
                }
                ++n;
            }
            if (this.started <= 0) break block48;
            ++this.points;
            n = this.started != 0 && Math.random() < 0.01 ? 1 : 0;
            n2 = 0;
            while (n2 < this.badRs.length) {
                block50: {
                    double d5;
                    double d6;
                    double d7;
                    block49: {
                        d7 = this.badRs[n2];
                        d6 = this.badTs[n2];
                        d5 = this.badVts[n2];
                        if (d7 != 0.0) break block49;
                        if (n == 0) break block50;
                        d7 = 370.0;
                        d6 = Math.PI * 2 * Math.random();
                        n = 0;
                    }
                    d5 += 3.0 * (Math.random() - 0.5);
                    d5 = Math.min(Math.max(-10.0, d5), 10.0);
                    d6 += d5 / d7;
                    if (d7 > (double)(160 + 5 * (n2 % 10))) {
                        d7 -= 2.0;
                    }
                    d6 += (double)(d6 > Math.PI ? -2 : (d6 < -Math.PI ? 2 : 0)) * Math.PI;
                    int n5 = 0;
                    while (n5 < this.dudeRs.length) {
                        d = Math.abs(this.dudeTs[n5] - d6);
                        if (this.alive(n5)) {
                            if (d < 0.01 && this.dudeRs[n5] < d7) {
                                this.dudeLives[n5] = Math.max(0.0, this.dudeLives[n5] - 0.06);
                                dArray2[n5] = d7;
                            }
                            if (d < 10.0 / d7 && Math.abs(this.dudeRs[n5] - d7) < 20.0) {
                                blArray[n2] = true;
                                this.points += 100;
                            }
                        }
                        ++n5;
                    }
                    this.badRs[n2] = d7;
                    this.badTs[n2] = d6;
                    this.badVts[n2] = d5;
                }
                ++n2;
            }
        }
        object = (Graphics2D)graphics.create();
        try {
            objectArray = new Color[]{Color.ORANGE, new Color(0x6060FF), Color.GREEN, Color.RED};
            int[] nArray3 = new int[4];
            nArray3[0] = -20;
            nArray3[2] = 20;
            nArray2 = nArray3;
            int[] nArray4 = new int[4];
            nArray4[0] = 7;
            nArray4[1] = 14;
            nArray4[2] = 7;
            nArray = nArray4;
            ((Graphics)object).setColor(Color.BLACK);
            ((Graphics)object).fillRect(0, 0, this.getWidth(), this.getHeight());
            ((Graphics)object).drawImage(this.sky, 0, 0, null);
            ((Graphics2D)object).translate(251, 251);
            ((Graphics2D)object).scale(1.0, -1.0);
            if (!this.rough) {
                ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            ((Graphics)object).setColor(new Color(32768));
            ((Graphics2D)object).setStroke(new BasicStroke(3.0f));
            ((Graphics)object).drawOval(-80, -80, 159, 159);
            ((Graphics2D)object).setStroke(new BasicStroke(2.0f));
            n = 0;
            while (n < this.dudeRs.length) {
                if (this.alive(n)) {
                    double d = this.dudeRs[n];
                    double d8 = this.dudeTs[n];
                    Graphics2D graphics2D = (Graphics2D)((Graphics)object).create();
                    try {
                        graphics2D.setColor(objectArray[n]);
                        graphics2D.rotate(d8);
                        graphics2D.translate(-10, 0);
                        graphics2D.translate(0.0, d);
                        graphics2D.fillRoundRect(0, 0, 20, 20, 10, 10);
                        graphics2D.setColor(objectArray[n].darker());
                        graphics2D.drawRoundRect(0, 0, 20, 20, 10, 10);
                        if (dArray2[n] > 0.0) {
                            graphics2D.setColor(new Color(-1593900801));
                            graphics2D.drawLine(10, (int)(dArray2[n] - d), 10, 18);
                        }
                        graphics2D.setColor(Color.WHITE);
                        graphics2D.fillOval(2, 10, 7, 7);
                        graphics2D.fillOval(11, 10, 7, 7);
                        graphics2D.setColor(Color.BLACK);
                        int n6 = -2 * Double.compare(dArray[n], 0.0);
                        int n7 = 2 * Double.compare(this.dudeVrs[n], 0.0);
                        graphics2D.fillOval(3 + n6, 11 + n7, 5, 5);
                        graphics2D.fillOval(12 + n6, 11 + n7, 5, 5);
                    }
                    catch (Throwable throwable) {
                        Object var17_46 = null;
                        graphics2D.dispose();
                        throw throwable;
                    }
                    {
                        Object var17_47 = null;
                    }
                    graphics2D.dispose();
                }
                ++n;
            }
            n = 0;
            while (n < this.badTs.length) {
                double d = this.badRs[n];
                double d9 = this.badTs[n];
                if (d != 0.0) {
                    Graphics2D graphics2D = (Graphics2D)((Graphics)object).create();
                    try {
                        graphics2D.rotate(d9);
                        graphics2D.translate(0.0, d);
                        graphics2D.setColor(Color.GRAY);
                        graphics2D.fillPolygon(nArray2, nArray, 4);
                        graphics2D.setColor(Color.GRAY.darker());
                        graphics2D.drawPolygon(nArray2, nArray, 4);
                        if (blArray[n]) {
                            graphics2D.setColor(new Color(-2130706688));
                            graphics2D.fillPolygon(nArray2, nArray, 4);
                            this.badRs[n] = 0.0;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var15_42 = null;
                        graphics2D.dispose();
                        throw throwable;
                    }
                    {
                        Object var15_43 = null;
                    }
                    graphics2D.dispose();
                }
                ++n;
            }
            Graphics2D graphics2D = (Graphics2D)((Graphics)object).create();
            try {
                graphics2D.setComposite(AlphaComposite.getInstance(10, 0.7f));
                int[] nArray5 = new int[]{-235, -235, 220, 220};
                int[] nArray6 = new int[]{10, -235, -235, 10};
                int n8 = 0;
                while (n8 < this.dudeRs.length) {
                    graphics2D.setColor(objectArray[n8]);
                    if (this.dudeLives[n8] > 1.0) {
                        graphics2D.drawRoundRect(nArray5[n8], nArray6[n8], 15, 225, 15, 15);
                    } else {
                        graphics2D.fillRoundRect(nArray5[n8], nArray6[n8], 15, (int)(this.dudeLives[n8] * 225.0), 15, 15);
                    }
                    ++n8;
                }
                if (this.started < 0) {
                    graphics2D.setColor(Color.BLACK);
                    graphics2D.fillRect(-251, -251, 501, 501);
                }
                graphics2D.setColor(Color.WHITE);
                graphics2D.scale(1.0, -1.0);
                if (this.started != 0) {
                    if (this.started < 0) {
                        graphics2D.drawString("Game Over - Press ESC to Reset", -100, 0);
                    }
                    graphics2D.drawString(String.valueOf(this.points), -15, 225);
                }
            }
            catch (Throwable throwable) {
                Object var13_24 = null;
                graphics2D.dispose();
                throw throwable;
            }
            {
                Object var13_25 = null;
                graphics2D.dispose();
            }
        }
        catch (Throwable throwable) {
            Object var19_48 = null;
            ((Graphics)object).dispose();
            throw throwable;
        }
        {
            Object var19_49 = null;
        }
        ((Graphics)object).dispose();
    }

    public void run() {
        this.sky = new BufferedImage(501, 501, 2);
        int n = 0;
        while (n < 100) {
            double d = 500.0 * Math.random();
            double d2 = 500.0 * Math.random();
            this.sky.setRGB((int)d, (int)d2, -1);
            ++n;
        }
        BufferedImage bufferedImage = new BufferedImage(401, 401, 2);
        int n2 = 65;
        int n3 = -200;
        while (n3 < 200) {
            int n4 = -200;
            while (n4 < 200) {
                double d = Math.pow(n3 * n3 + n4 * n4, 0.5);
                double d3 = d < (double)n2 ? d / (double)n2 : Math.pow(d, 4.0) / 1.4E9;
                d3 = Math.min(1.0, d3);
                int n5 = d < (double)n2 ? 255 : this.scale(d3, 255, 0);
                int n6 = d < (double)n2 ? this.scale(d3, 96, 85) : this.scale(d3, 135, 135);
                int n7 = d < (double)n2 ? this.scale(d3, 96, 80) : this.scale(d3, 206, 206);
                int n8 = d < (double)n2 ? this.scale(d3, 80, 69) : this.scale(d3, 250, 250);
                int n9 = n5 << 24 | n6 << 16 | n7 << 8 | n8;
                bufferedImage.setRGB(n3 + 200, n4 + 200, d < (double)n2 ? n9 : (d < 79.0 ? -11186107 : n9));
                ++n4;
            }
            ++n3;
        }
        this.sky.getGraphics().drawImage(bufferedImage, 51, 51, null);
        JFrame jFrame = new JFrame("RoundWorld");
        jFrame.setContentPane(this);
        jFrame.addKeyListener(this);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setResizable(false);
        jFrame.setSize(500, 500);
        jFrame.setVisible(true);
        jFrame.setSize(1001 - this.getWidth(), 1001 - this.getHeight());
        jFrame.setVisible(false);
        jFrame.setVisible(true);
    }

    private int scale(double d, int n, int n2) {
        return (int)(d * (double)n2 + (1.0 - d) * (double)n);
    }
}

