/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;

public class Domino4K
extends Frame
implements Runnable {
    private int n1;
    private int n2;
    private int x;
    private int y;
    private int r;
    private int v1;
    private int v2;
    private int level;
    private int[][] tablero;
    private int[][] tableroR;
    private static int sx = 8;
    private static int sy = 15;
    private boolean playing;
    private int score;
    private int bestScore;
    private int chain;
    private int piezas;
    private int estado;
    Image bImg;
    Graphics buff;
    private static int W = 600;
    private static int H = 600;
    private static int cs = 36;
    private static Color[] col = new Color[]{new Color(240, 240, 180), new Color(180, 240, 240), new Color(240, 180, 240), new Color(180, 240, 180), new Color(180, 180, 240), new Color(240, 180, 180), new Color(180, 120, 180), new Color(180, 180, 130), new Color(120, 180, 180), new Color(220, 220, 220)};
    private static int[] keys = new int[256];
    double moveTime = 0.0;
    double rotateTime = 0.0;
    double downTime = 0.0;
    int diying;

    public Domino4K() {
        super("Puzzling Dominoes 4K ");
        this.enableEvents(8L);
        this.setSize(W, H);
        this.tablero = new int[sx][sy];
        this.tableroR = new int[sx][sy];
        this.setVisible(true);
        this.y = 0;
        this.x = 0;
        this.r = 1;
        this.v1 = 2;
        this.v2 = 4;
        this.chain = 1;
    }

    public void addNotify() {
        super.addNotify();
        this.bImg = this.createImage(W, H);
        this.buff = this.bImg.getGraphics();
        new Thread(this).start();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            System.exit(0);
        }
        Domino4K.keys[keyEvent.getKeyCode()] = keyEvent.getID() & 1;
    }

    public void run() {
        long l = System.currentTimeMillis();
        while (true) {
            double d = (double)(System.currentTimeMillis() - l) / 1000.0;
            l = System.currentTimeMillis();
            this.doGame(d);
            this.doRender();
            this.doPaint();
        }
    }

    private void drawBlock(int n, int n2, int n3, int n4) {
        this.buff.setColor(col[n3 - 1]);
        if (n4 > 0) {
            this.buff.fill3DRect(20 + n * cs, 30 + n2 * cs, cs, cs, true);
            if ((n3 & 1) != 0) {
                this.buff.setColor(new Color(100, 100, 100));
                this.buff.fillOval(20 + n * cs + cs / 2 - 3, 30 + n2 * cs + cs / 2 - 3, 6, 6);
                this.buff.setColor(new Color(255, 255, 255));
                this.buff.fillOval(20 + n * cs + cs / 2, 30 + n2 * cs + cs / 2, 3, 3);
            }
            if ((n3 == 2 || n3 == 3) && (n4 == 1 || n4 == 3) || n3 > 3) {
                this.buff.setColor(new Color(100, 100, 100));
                this.buff.fillOval(20 + n * cs + cs / 4 - 3, 30 + n2 * cs + cs / 4 - 3, 6, 6);
                this.buff.fillOval(20 + n * cs + 3 * cs / 4 - 3, 30 + n2 * cs + 3 * cs / 4 - 3, 6, 6);
                this.buff.setColor(new Color(255, 255, 255));
                this.buff.fillOval(20 + n * cs + cs / 4, 30 + n2 * cs + cs / 4, 3, 3);
                this.buff.fillOval(20 + n * cs + 3 * cs / 4, 30 + n2 * cs + 3 * cs / 4, 3, 3);
            }
            if ((n3 == 2 || n3 == 3) && (n4 == 2 || n4 == 4) || n3 > 3) {
                this.buff.setColor(new Color(100, 100, 100));
                this.buff.fillOval(20 + n * cs + 3 * cs / 4 - 3, 30 + n2 * cs + cs / 4 - 3, 6, 6);
                this.buff.fillOval(20 + n * cs + cs / 4 - 3, 30 + n2 * cs + 3 * cs / 4 - 3, 6, 6);
                this.buff.setColor(new Color(255, 255, 255));
                this.buff.fillOval(20 + n * cs + 3 * cs / 4, 30 + n2 * cs + cs / 4, 3, 3);
                this.buff.fillOval(20 + n * cs + cs / 4, 30 + n2 * cs + 3 * cs / 4, 3, 3);
            }
            if ((n3 == 6 || n3 == 7) && (n4 == 2 || n4 == 4) || n3 > 7) {
                this.buff.setColor(new Color(100, 100, 100));
                this.buff.fillOval(20 + n * cs + cs / 2 - 3, 30 + n2 * cs + cs / 4 - 3, 6, 6);
                this.buff.fillOval(20 + n * cs + cs / 2 - 3, 30 + n2 * cs + 3 * cs / 4 - 3, 6, 6);
                this.buff.setColor(new Color(255, 255, 255));
                this.buff.fillOval(20 + n * cs + cs / 2, 30 + n2 * cs + cs / 4, 3, 3);
                this.buff.fillOval(20 + n * cs + cs / 2, 30 + n2 * cs + 3 * cs / 4, 3, 3);
            }
            if ((n3 == 6 || n3 == 7) && (n4 == 1 || n4 == 3) || n3 > 7) {
                this.buff.setColor(new Color(100, 100, 100));
                this.buff.fillOval(20 + n * cs + cs / 4 - 3, 30 + n2 * cs + cs / 2 - 3, 6, 6);
                this.buff.fillOval(20 + n * cs + 3 * cs / 4 - 3, 30 + n2 * cs + cs / 2 - 3, 6, 6);
                this.buff.setColor(new Color(255, 255, 255));
                this.buff.fillOval(20 + n * cs + cs / 4, 30 + n2 * cs + cs / 2, 3, 3);
                this.buff.fillOval(20 + n * cs + 3 * cs / 4, 30 + n2 * cs + cs / 2, 3, 3);
            }
        } else {
            this.buff.fill3DRect(20 + n * cs + cs / 2 + n4, 30 + n2 * cs + cs / 2 + n4, -2 * n4, -2 * n4, true);
        }
    }

    public void doRender() {
        this.buff.setColor(new Color(255, 255, 255));
        this.buff.fillRect(0, 0, W, H);
        this.buff.setColor(new Color(0, 0, 0));
        this.buff.fillRect(15, 30, 5, 5 + cs * sy);
        this.buff.fillRect(20 + cs * sx, 30, 5, 5 + cs * sy);
        this.buff.fillRect(20, cs * sy + 30, cs * sx, 5);
        this.buff.setFont(new Font("Arial", 1, 14));
        this.buff.drawString("HiScore: " + this.bestScore, 20 + cs * sx + 30, 40);
        if (this.playing) {
            int n = 0;
            while (n < sx) {
                int n2 = 0;
                while (n2 < sy) {
                    if (this.tablero[n][n2] > 0) {
                        this.drawBlock(n, n2, this.tablero[n][n2], this.tableroR[n][n2]);
                    }
                    ++n2;
                }
                ++n;
            }
            if (this.estado == 1) {
                switch (this.r) {
                    case 1: {
                        this.drawBlock(this.x, this.y, this.v1, this.r);
                        this.drawBlock(this.x, this.y + 1, this.v2, this.r);
                        break;
                    }
                    case 2: {
                        this.drawBlock(this.x, this.y + 1, this.v1, this.r);
                        this.drawBlock(this.x + 1, this.y + 1, this.v2, this.r);
                        break;
                    }
                    case 3: {
                        this.drawBlock(this.x + 1, this.y, this.v2, this.r);
                        this.drawBlock(this.x + 1, this.y + 1, this.v1, this.r);
                        break;
                    }
                    case 4: {
                        this.drawBlock(this.x, this.y, this.v2, this.r);
                        this.drawBlock(this.x + 1, this.y, this.v1, this.r);
                        break;
                    }
                }
            }
            this.drawBlock(sx + 3, 5, this.n1, 1);
            this.drawBlock(sx + 3, 6, this.n2, 1);
            this.buff.setColor(new Color(0, 0, 0));
            this.buff.drawString("Score: " + this.score, 20 + cs * sx + 30, 60);
            this.buff.drawString("Level: " + this.level, 20 + cs * sx + 30, 80);
            if (this.chain > 2) {
                this.buff.drawString("Chain: x" + (this.chain - 1), 20 + cs * sx + 30, 100);
            }
        } else {
            this.buff.drawString("Press SPACE to Start", 20 + cs * sx / 2 - 80, 150);
        }
    }

    public void doPaint() {
        Graphics graphics = this.getGraphics();
        graphics.drawImage(this.bImg, 0, 0, this);
        graphics.dispose();
    }

    public void doGame(double d) {
        if (this.playing) {
            int n;
            int n2;
            if (this.estado == 1) {
                this.moveTime += d;
                this.rotateTime += d;
                this.downTime += (1.0 + (double)(this.level - 1) / 4.0) * d;
                if (keys[39] != 0 && this.moveTime > 0.08) {
                    switch (this.r) {
                        case 1: {
                            if (this.x + 1 >= sx || this.tablero[this.x + 1][this.y] != 0 || this.tablero[this.x + 1][this.y + 1] != 0) break;
                            ++this.x;
                            this.moveTime = 0.0;
                            break;
                        }
                        case 2: {
                            if (this.x + 2 >= sx || this.tablero[this.x + 2][this.y + 1] != 0) break;
                            ++this.x;
                            this.moveTime = 0.0;
                            break;
                        }
                        case 3: {
                            if (this.x + 2 >= sx || this.tablero[this.x + 2][this.y] != 0 || this.tablero[this.x + 2][this.y + 1] != 0) break;
                            ++this.x;
                            this.moveTime = 0.0;
                            break;
                        }
                        case 4: {
                            if (this.x + 2 >= sx || this.tablero[this.x + 2][this.y] != 0) break;
                            ++this.x;
                            this.moveTime = 0.0;
                            break;
                        }
                    }
                }
                if (keys[37] != 0 && this.moveTime > 0.08) {
                    switch (this.r) {
                        case 1: {
                            if (this.x - 1 < 0 || this.tablero[this.x - 1][this.y] != 0 || this.tablero[this.x - 1][this.y + 1] != 0) break;
                            --this.x;
                            this.moveTime = 0.0;
                            break;
                        }
                        case 2: {
                            if (this.x - 1 < 0 || this.tablero[this.x - 1][this.y + 1] != 0) break;
                            --this.x;
                            this.moveTime = 0.0;
                            break;
                        }
                        case 3: {
                            if (this.x < 0 || this.tablero[this.x][this.y] != 0 || this.tablero[this.x][this.y + 1] != 0) break;
                            --this.x;
                            this.moveTime = 0.0;
                            break;
                        }
                        case 4: {
                            if (this.x - 1 < 0 || this.tablero[this.x - 1][this.y] != 0) break;
                            --this.x;
                            this.moveTime = 0.0;
                            break;
                        }
                    }
                }
                if (keys[38] != 0 && this.rotateTime > 0.1) {
                    switch (this.r) {
                        case 1: {
                            if (this.x + 1 >= sx || this.tablero[this.x + 1][this.y + 1] != 0) break;
                            this.r = 2;
                            this.rotateTime = 0.0;
                            Domino4K.keys[38] = 0;
                            break;
                        }
                        case 2: {
                            this.r = 3;
                            this.rotateTime = 0.0;
                            Domino4K.keys[38] = 0;
                            break;
                        }
                        case 3: {
                            if (this.x < 0 || this.tablero[this.x][this.y] != 0) break;
                            this.r = 4;
                            this.rotateTime = 0.0;
                            Domino4K.keys[38] = 0;
                            break;
                        }
                        case 4: {
                            if (this.y + 1 >= sy || this.tablero[this.x][this.y + 1] != 0) break;
                            this.r = 1;
                            this.rotateTime = 0.0;
                            Domino4K.keys[38] = 0;
                            break;
                        }
                    }
                }
                if (keys[40] != 0 && this.moveTime > 0.05 || this.downTime > 0.4) {
                    n2 = 0;
                    switch (this.r) {
                        case 1: {
                            if (this.y + 2 != sy && this.tablero[this.x][this.y + 2] == 0) break;
                            n2 = 1;
                            break;
                        }
                        case 2: {
                            if (this.y + 2 != sy && this.tablero[this.x][this.y + 2] == 0 && this.tablero[this.x + 1][this.y + 2] == 0) break;
                            n2 = 1;
                            break;
                        }
                        case 3: {
                            if (this.y + 2 != sy && this.tablero[this.x + 1][this.y + 2] == 0) break;
                            n2 = 1;
                            break;
                        }
                        case 4: {
                            if (this.y + 1 != sy && this.tablero[this.x][this.y + 1] == 0 && this.tablero[this.x + 1][this.y + 1] == 0) break;
                            n2 = 1;
                            break;
                        }
                    }
                    if (n2 != 0) {
                        switch (this.r) {
                            case 1: {
                                this.tablero[this.x][this.y] = this.v1;
                                this.tablero[this.x][this.y + 1] = this.v2;
                                this.tableroR[this.x][this.y] = this.r;
                                this.tableroR[this.x][this.y + 1] = this.r;
                                break;
                            }
                            case 2: {
                                this.tablero[this.x][this.y + 1] = this.v1;
                                this.tablero[this.x + 1][this.y + 1] = this.v2;
                                this.tableroR[this.x][this.y + 1] = this.r;
                                this.tableroR[this.x + 1][this.y + 1] = this.r;
                                break;
                            }
                            case 3: {
                                this.tablero[this.x + 1][this.y] = this.v2;
                                this.tablero[this.x + 1][this.y + 1] = this.v1;
                                this.tableroR[this.x + 1][this.y] = this.r;
                                this.tableroR[this.x + 1][this.y + 1] = this.r;
                                break;
                            }
                            case 4: {
                                this.tablero[this.x][this.y] = this.v2;
                                this.tablero[this.x + 1][this.y] = this.v1;
                                this.tableroR[this.x][this.y] = this.r;
                                this.tableroR[this.x + 1][this.y] = this.r;
                                break;
                            }
                        }
                        this.estado = 2;
                    } else {
                        ++this.y;
                        this.moveTime = 0.0;
                        this.downTime = 0.0;
                    }
                }
            } else if (this.estado == 2) {
                this.moveTime += d;
                if (this.moveTime > 0.05) {
                    n2 = 0;
                    int n3 = 0;
                    while (n3 < sx) {
                        n = sy - 1;
                        while (n > 0) {
                            if (this.tablero[n3][n - 1] > 0 && this.tablero[n3][n] == 0) {
                                this.tablero[n3][n] = this.tablero[n3][n - 1];
                                this.tablero[n3][n - 1] = 0;
                                this.tableroR[n3][n] = this.tableroR[n3][n - 1];
                                this.tableroR[n3][n - 1] = 0;
                                n2 = 1;
                            }
                            --n;
                        }
                        ++n3;
                    }
                    if (n2 == 0) {
                        this.estado = 3;
                    }
                    this.moveTime = 0.0;
                }
            }
            if (this.estado == 3) {
                int n4;
                n2 = 0;
                int[][] nArray = new int[50][2];
                n = 0;
                int n5 = 0;
                int n6 = 0;
                while (n6 < sx) {
                    n4 = sy - 1;
                    while (n4 >= 0) {
                        if (this.tablero[n6][n4] > 1) {
                            int n7 = this.tablero[n6][n4];
                            nArray[0][0] = n6;
                            nArray[0][1] = n4;
                            n5 = 1;
                            n = 0;
                            while (n < n5) {
                                if (nArray[n][1] - 1 >= 0 && this.tablero[nArray[n][0]][nArray[n][1] - 1] == n7 && !this.isIn(nArray, n5, nArray[n][0], nArray[n][1] - 1) && this.tableroR[nArray[n][0]][nArray[n][1] - 1] > 0) {
                                    nArray[n5][0] = nArray[n][0];
                                    nArray[n5][1] = nArray[n][1] - 1;
                                    ++n5;
                                }
                                if (nArray[n][1] + 1 < sy && this.tablero[nArray[n][0]][nArray[n][1] + 1] == n7 && !this.isIn(nArray, n5, nArray[n][0], nArray[n][1] + 1) && this.tableroR[nArray[n][0]][nArray[n][1] + 1] > 0) {
                                    nArray[n5][0] = nArray[n][0];
                                    nArray[n5][1] = nArray[n][1] + 1;
                                    ++n5;
                                }
                                if (nArray[n][0] + 1 < sx && this.tablero[nArray[n][0] + 1][nArray[n][1]] == n7 && !this.isIn(nArray, n5, nArray[n][0] + 1, nArray[n][1]) && this.tableroR[nArray[n][0] + 1][nArray[n][1]] > 0) {
                                    nArray[n5][0] = nArray[n][0] + 1;
                                    nArray[n5][1] = nArray[n][1];
                                    ++n5;
                                }
                                if (nArray[n][0] - 1 >= 0 && this.tablero[nArray[n][0] - 1][nArray[n][1]] == n7 && !this.isIn(nArray, n5, nArray[n][0] - 1, nArray[n][1]) && this.tableroR[nArray[n][0] - 1][nArray[n][1]] > 0) {
                                    nArray[n5][0] = nArray[n][0] - 1;
                                    nArray[n5][1] = nArray[n][1];
                                    ++n5;
                                }
                                ++n;
                            }
                            if (n5 >= n7) {
                                this.piezas += n5;
                                if (this.piezas >= 50) {
                                    ++this.level;
                                    this.piezas -= 50;
                                }
                                this.score += n5 * n7 * this.chain;
                                int n8 = 0;
                                while (n8 < n5) {
                                    int n9;
                                    this.tableroR[nArray[n8][0]][nArray[n8][1]] = n9 = -cs / 2;
                                    if (nArray[n8][1] - 1 >= 0 && this.tablero[nArray[n8][0]][nArray[n8][1] - 1] == 1) {
                                        this.tableroR[nArray[n8][0]][nArray[n8][1] - 1] = n9;
                                    }
                                    if (nArray[n8][1] + 1 < sy && this.tablero[nArray[n8][0]][nArray[n8][1] + 1] == 1) {
                                        this.tableroR[nArray[n8][0]][nArray[n8][1] + 1] = n9;
                                    }
                                    if (nArray[n8][0] + 1 < sx && this.tablero[nArray[n8][0] + 1][nArray[n8][1]] == 1) {
                                        this.tableroR[nArray[n8][0] + 1][nArray[n8][1]] = n9;
                                    }
                                    if (nArray[n8][0] - 1 >= 0 && this.tablero[nArray[n8][0] - 1][nArray[n8][1]] == 1) {
                                        this.tableroR[nArray[n8][0] - 1][nArray[n8][1]] = n9;
                                    }
                                    ++n8;
                                }
                                n2 = 1;
                            }
                        }
                        --n4;
                    }
                    ++n6;
                }
                if (n2 != 0) {
                    ++this.chain;
                    this.estado = 4;
                } else {
                    n6 = 1;
                    n4 = 0;
                    while (n4 < sx) {
                        if (this.tablero[n4][0] > 0) {
                            n6 = 0;
                        }
                        ++n4;
                    }
                    if (n6 != 0) {
                        this.chain = 1;
                        this.estado = 1;
                        this.v1 = this.n1;
                        this.v2 = this.n2;
                        this.n1 = (int)(Math.random() * 7.0 + 1.0);
                        this.n2 = (int)(Math.random() * 7.0 + 1.0);
                        this.r = 1;
                        this.x = sx / 2;
                        this.y = 0;
                    } else {
                        this.estado = 5;
                        this.diying = sy - 1;
                        this.moveTime = 0.0;
                    }
                }
            }
            if (this.estado == 4) {
                n2 = 0;
                int n10 = 0;
                while (n10 < sx) {
                    n = 0;
                    while (n < sy) {
                        if (this.tableroR[n10][n] < 0) {
                            n2 = 1;
                            int[] nArray = this.tableroR[n10];
                            int n11 = n;
                            nArray[n11] = nArray[n11] + 1;
                            if (this.tableroR[n10][n] == 0) {
                                this.tablero[n10][n] = 0;
                            }
                        }
                        ++n;
                    }
                    ++n10;
                }
                if (n2 == 0) {
                    this.estado = 2;
                }
            }
            if (this.estado == 5) {
                this.moveTime += d;
                if (this.moveTime >= 0.05) {
                    n2 = 0;
                    while (n2 < sx) {
                        this.tablero[n2][this.diying] = 10;
                        this.tableroR[n2][this.diying] = -cs / 2;
                        ++n2;
                    }
                    --this.diying;
                    if (this.diying < 0) {
                        if (this.score > this.bestScore) {
                            this.bestScore = this.score;
                        }
                        this.playing = false;
                    }
                    this.moveTime = 0.0;
                }
            }
        } else if (keys[32] > 0) {
            int n = 0;
            while (n < sx) {
                int n12 = 0;
                while (n12 < sy) {
                    this.tablero[n][n12] = 0;
                    this.tableroR[n][n12] = 0;
                    ++n12;
                }
                ++n;
            }
            this.playing = true;
            this.estado = 1;
            this.chain = 1;
            this.level = 1;
            this.score = 0;
            this.x = sx / 2;
            this.y = 0;
            this.r = 1;
            this.v1 = (int)(Math.random() * 7.0 + 1.0);
            this.v2 = (int)(Math.random() * 7.0 + 1.0);
            this.n1 = (int)(Math.random() * 7.0 + 1.0);
            this.n2 = (int)(Math.random() * 7.0 + 1.0);
        }
    }

    private boolean isIn(int[][] nArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n) {
            if (nArray[n4][0] == n2 && nArray[n4][1] == n3) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        new Domino4K();
    }
}

