/*
 * Decompiled with CFR 0.152.
 */
package proguard.retrace;

import java.io.File;
import java.io.IOException;
import proguard.obfuscate.MappingProcessor;
import proguard.obfuscate.MappingReader;
import proguard.retrace.StackTrace;

public class ReTrace {
    private static final String VERBOSE_OPTION = "-verbose";
    private boolean verbose;
    private File mappingFile;
    private File stackTraceFile;

    public ReTrace(boolean bl, File file) {
        this(bl, file, null);
    }

    public ReTrace(boolean bl, File file, File file2) {
        this.verbose = bl;
        this.mappingFile = file;
        this.stackTraceFile = file2;
    }

    public void execute() throws IOException {
        StackTrace stackTrace = new StackTrace(this.verbose);
        MappingReader mappingReader = new MappingReader(this.mappingFile);
        stackTrace.read(this.stackTraceFile);
        mappingReader.pump((MappingProcessor)stackTrace);
        stackTrace.print();
    }

    public static void main(String[] stringArray) {
        File file;
        if (stringArray.length < 1) {
            System.err.println("Usage: java proguard.ReTrace [-verbose] <mapping_file> [<stacktrace_file>]");
            System.exit(-1);
        }
        int n = 0;
        boolean bl = false;
        if (stringArray[n].equals(VERBOSE_OPTION)) {
            bl = true;
            ++n;
            if (stringArray.length < 2) {
                System.err.println("Usage: java proguard.ReTrace [-verbose] <mapping_file> [<stacktrace_file>]");
                System.exit(-1);
            }
        }
        File file2 = new File(stringArray[n++]);
        if (n < stringArray.length) {
            ++n;
            file = new File(stringArray[n]);
        } else {
            file = null;
        }
        File file3 = file;
        ReTrace reTrace = new ReTrace(bl, file2, file3);
        try {
            reTrace.execute();
        }
        catch (IOException iOException) {
            if (bl) {
                iOException.printStackTrace();
            } else {
                System.err.println("Error: " + iOException.getMessage());
            }
            System.exit(1);
        }
        System.exit(0);
    }
}

