/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import proguard.ClassSpecification;
import proguard.classfile.util.ClassUtil;
import proguard.gui.ClassSpecificationDialog;
import proguard.gui.GUIResources;
import proguard.gui.ListPanel;

class ClassSpecificationsPanel
extends ListPanel {
    private ClassSpecificationDialog classSpecificationDialog;

    public ClassSpecificationsPanel(JFrame jFrame, boolean bl) {
        this.list.setCellRenderer(new MyListCellRenderer());
        this.classSpecificationDialog = new ClassSpecificationDialog(jFrame, bl);
        this.addAddButton();
        this.addEditButton();
        this.addRemoveButton();
        this.addUpButton();
        this.addDownButton();
        this.enableSelectionButtons();
    }

    protected void addAddButton() {
        JButton jButton = new JButton(GUIResources.getMessage("add"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassSpecificationsPanel.this.classSpecificationDialog.setClassSpecification(new ClassSpecification());
                int n = ClassSpecificationsPanel.this.classSpecificationDialog.showDialog();
                if (n == 0) {
                    ClassSpecificationsPanel.this.addElement(ClassSpecificationsPanel.this.classSpecificationDialog.getClassSpecification());
                }
            }
        });
        this.addButton(jButton);
    }

    protected void addEditButton() {
        JButton jButton = new JButton(GUIResources.getMessage("edit"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassSpecification classSpecification = (ClassSpecification)ClassSpecificationsPanel.this.list.getSelectedValue();
                ClassSpecificationsPanel.this.classSpecificationDialog.setClassSpecification(classSpecification);
                int n = ClassSpecificationsPanel.this.classSpecificationDialog.showDialog();
                if (n == 0) {
                    ClassSpecificationsPanel.this.setElementAt(ClassSpecificationsPanel.this.classSpecificationDialog.getClassSpecification(), ClassSpecificationsPanel.this.list.getSelectedIndex());
                }
            }
        });
        this.addButton(jButton);
    }

    public void setClassSpecifications(List list) {
        this.listModel.clear();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.listModel.addElement(list.get(i));
            }
        }
        this.enableSelectionButtons();
    }

    public List getClassSpecifications() {
        int n = this.listModel.size();
        if (n == 0) {
            return null;
        }
        ArrayList arrayList = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.listModel.get(i));
        }
        return arrayList;
    }

    private static class MyListCellRenderer
    implements ListCellRenderer {
        JLabel label = new JLabel();

        private MyListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ClassSpecification classSpecification = (ClassSpecification)object;
            String string = classSpecification.comments;
            this.label.setText(string != null ? string.trim() : (classSpecification.className != null ? GUIResources.getMessage("class") + ' ' + ClassUtil.externalClassName((String)classSpecification.className) : (classSpecification.extendsClassName != null ? GUIResources.getMessage("extensionsOf") + ' ' + ClassUtil.externalClassName((String)classSpecification.extendsClassName) : GUIResources.getMessage("specificationNumber") + n)));
            if (bl) {
                this.label.setBackground(jList.getSelectionBackground());
                this.label.setForeground(jList.getSelectionForeground());
            } else {
                this.label.setBackground(jList.getBackground());
                this.label.setForeground(jList.getForeground());
            }
            this.label.setOpaque(true);
            return this.label;
        }
    }
}

