/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import proguard.ClassSpecification;
import proguard.classfile.util.ClassUtil;
import proguard.gui.ClassMemberSpecificationsPanel;
import proguard.gui.GUIResources;

class ClassSpecificationDialog
extends JDialog {
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    private JTextArea commentsTextArea = new JTextArea(4, 20);
    private JRadioButton keepClassesAndMembersRadioButton = new JRadioButton(GUIResources.getMessage("keep"));
    private JRadioButton keepClassMembersRadioButton = new JRadioButton(GUIResources.getMessage("keepClassMembers"));
    private JRadioButton keepClassesWithMembersRadioButton = new JRadioButton(GUIResources.getMessage("keepClassesWithMembers"));
    private JRadioButton[] publicRadioButtons;
    private JRadioButton[] finalRadioButtons;
    private JRadioButton[] interfaceRadioButtons;
    private JRadioButton[] abstractRadioButtons;
    private JTextField classNameTextField = new JTextField(20);
    private JTextField extendsClassNameTextField = new JTextField(20);
    private ClassMemberSpecificationsPanel classMembersPanel;
    private int returnValue;

    public ClassSpecificationDialog(JFrame jFrame, boolean bl) {
        super((Frame)jFrame, true);
        this.setResizable(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridwidth = 0;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridwidth = 0;
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 0.0;
        gridBagConstraints5.anchor = 18;
        gridBagConstraints5.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridwidth = 0;
        gridBagConstraints6.fill = 1;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.anchor = 18;
        gridBagConstraints6.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.anchor = 10;
        gridBagConstraints7.insets = new Insets(2, 10, 2, 10);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridwidth = 0;
        gridBagConstraints8.anchor = 10;
        gridBagConstraints8.insets = gridBagConstraints7.insets;
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.weightx = 1.0;
        gridBagConstraints9.weighty = 1.0;
        gridBagConstraints9.anchor = 14;
        gridBagConstraints9.insets = new Insets(4, 4, 8, 4);
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridwidth = 0;
        gridBagConstraints10.weighty = 1.0;
        gridBagConstraints10.anchor = 14;
        gridBagConstraints10.insets = gridBagConstraints9.insets;
        GridBagLayout gridBagLayout = new GridBagLayout();
        Border border = BorderFactory.createEtchedBorder(0);
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(BorderFactory.createTitledBorder(border, GUIResources.getMessage("comments")));
        JScrollPane jScrollPane = new JScrollPane(this.commentsTextArea);
        jScrollPane.setBorder(this.classNameTextField.getBorder());
        jPanel.add((Component)jScrollPane, gridBagConstraints4);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.keepClassesAndMembersRadioButton);
        buttonGroup.add(this.keepClassMembersRadioButton);
        buttonGroup.add(this.keepClassesWithMembersRadioButton);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        jPanel2.setBorder(BorderFactory.createTitledBorder(border, GUIResources.getMessage("keepTitle")));
        jPanel2.add((Component)this.keepClassesAndMembersRadioButton, gridBagConstraints4);
        jPanel2.add((Component)this.keepClassMembersRadioButton, gridBagConstraints4);
        jPanel2.add((Component)this.keepClassesWithMembersRadioButton, gridBagConstraints4);
        JPanel jPanel3 = new JPanel(gridBagLayout);
        jPanel3.setBorder(BorderFactory.createTitledBorder(border, GUIResources.getMessage("access")));
        jPanel3.add(Box.createGlue(), gridBagConstraints7);
        jPanel3.add((Component)new JLabel(GUIResources.getMessage("required")), gridBagConstraints7);
        jPanel3.add((Component)new JLabel(GUIResources.getMessage("not")), gridBagConstraints7);
        jPanel3.add((Component)new JLabel(GUIResources.getMessage("dontCare")), gridBagConstraints7);
        jPanel3.add(Box.createGlue(), gridBagConstraints4);
        this.publicRadioButtons = this.addRadioButtonTriplet("Public", jPanel3);
        this.finalRadioButtons = this.addRadioButtonTriplet("Final", jPanel3);
        this.interfaceRadioButtons = this.addRadioButtonTriplet("Interface", jPanel3);
        this.abstractRadioButtons = this.addRadioButtonTriplet("Abstract", jPanel3);
        JPanel jPanel4 = new JPanel(gridBagLayout);
        jPanel4.setBorder(BorderFactory.createTitledBorder(border, GUIResources.getMessage("class")));
        jPanel4.add((Component)this.classNameTextField, gridBagConstraints4);
        JPanel jPanel5 = new JPanel(gridBagLayout);
        jPanel5.setBorder(BorderFactory.createTitledBorder(border, GUIResources.getMessage("extendsImplementsClass")));
        jPanel5.add((Component)this.extendsClassNameTextField, gridBagConstraints4);
        this.classMembersPanel = new ClassMemberSpecificationsPanel(this, bl);
        this.classMembersPanel.setBorder(BorderFactory.createTitledBorder(border, GUIResources.getMessage("classMembers")));
        JButton jButton = new JButton(GUIResources.getMessage("ok"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassSpecificationDialog.this.returnValue = 0;
                ClassSpecificationDialog.this.hide();
            }
        });
        JButton jButton2 = new JButton(GUIResources.getMessage("cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassSpecificationDialog.this.hide();
            }
        });
        JPanel jPanel6 = new JPanel(gridBagLayout);
        jPanel6.add((Component)jPanel, gridBagConstraints5);
        if (bl) {
            jPanel6.add((Component)jPanel2, gridBagConstraints5);
        }
        jPanel6.add((Component)jPanel3, gridBagConstraints5);
        jPanel6.add((Component)jPanel4, gridBagConstraints5);
        jPanel6.add((Component)jPanel5, gridBagConstraints5);
        jPanel6.add((Component)this.classMembersPanel, gridBagConstraints6);
        jPanel6.add((Component)jButton, gridBagConstraints9);
        jPanel6.add((Component)jButton2, gridBagConstraints10);
        this.getContentPane().add(jPanel6);
    }

    private JRadioButton[] addRadioButtonTriplet(String string, JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.weightx = 1.0;
        JRadioButton jRadioButton = new JRadioButton();
        JRadioButton jRadioButton2 = new JRadioButton();
        JRadioButton jRadioButton3 = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        jPanel.add((Component)new JLabel(string), gridBagConstraints);
        jPanel.add((Component)jRadioButton, gridBagConstraints2);
        jPanel.add((Component)jRadioButton2, gridBagConstraints2);
        jPanel.add((Component)jRadioButton3, gridBagConstraints2);
        jPanel.add(Box.createGlue(), gridBagConstraints3);
        return new JRadioButton[]{jRadioButton, jRadioButton2, jRadioButton3};
    }

    public void setClassSpecification(ClassSpecification classSpecification) {
        String string = classSpecification.className;
        String string2 = classSpecification.extendsClassName;
        boolean bl = classSpecification.markClassFiles;
        boolean bl2 = classSpecification.markConditionally;
        String string3 = classSpecification.comments;
        List list = classSpecification.fieldSpecifications;
        List list2 = classSpecification.methodSpecifications;
        this.commentsTextArea.setText(string3 == null ? "" : string3);
        JRadioButton jRadioButton = bl2 ? this.keepClassesWithMembersRadioButton : (bl ? this.keepClassesAndMembersRadioButton : this.keepClassMembersRadioButton);
        jRadioButton.setSelected(true);
        this.setClassSpecificationRadioButtons(classSpecification, 1, this.publicRadioButtons);
        this.setClassSpecificationRadioButtons(classSpecification, 16, this.finalRadioButtons);
        this.setClassSpecificationRadioButtons(classSpecification, 512, this.interfaceRadioButtons);
        this.setClassSpecificationRadioButtons(classSpecification, 1024, this.abstractRadioButtons);
        this.classNameTextField.setText(string == null ? "*" : ClassUtil.externalClassName((String)string));
        this.extendsClassNameTextField.setText(string2 == null ? "" : ClassUtil.externalClassName((String)string2));
        this.classMembersPanel.setClassMemberSpecifications(list, list2);
    }

    public ClassSpecification getClassSpecification() {
        String string = this.commentsTextArea.getText();
        String string2 = this.classNameTextField.getText();
        String string3 = this.extendsClassNameTextField.getText();
        boolean bl = !this.keepClassMembersRadioButton.isSelected();
        boolean bl2 = this.keepClassesWithMembersRadioButton.isSelected();
        ClassSpecification classSpecification = new ClassSpecification(0, 0, string2.equals("") || string2.equals("*") ? null : ClassUtil.internalClassName((String)string2), string3.equals("") ? null : ClassUtil.internalClassName((String)string3), bl, bl2, string.equals("") ? null : string);
        this.getClassSpecificationRadioButtons(classSpecification, 1, this.publicRadioButtons);
        this.getClassSpecificationRadioButtons(classSpecification, 16, this.finalRadioButtons);
        this.getClassSpecificationRadioButtons(classSpecification, 512, this.interfaceRadioButtons);
        this.getClassSpecificationRadioButtons(classSpecification, 1024, this.abstractRadioButtons);
        classSpecification.fieldSpecifications = this.classMembersPanel.getClassMemberSpecifications(true);
        classSpecification.methodSpecifications = this.classMembersPanel.getClassMemberSpecifications(false);
        return classSpecification;
    }

    public int showDialog() {
        this.returnValue = 1;
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.show();
        return this.returnValue;
    }

    private void setClassSpecificationRadioButtons(ClassSpecification classSpecification, int n, JRadioButton[] jRadioButtonArray) {
        int n2 = (classSpecification.requiredSetAccessFlags & n) != 0 ? 0 : ((classSpecification.requiredUnsetAccessFlags & n) != 0 ? 1 : 2);
        jRadioButtonArray[n2].setSelected(true);
    }

    private void getClassSpecificationRadioButtons(ClassSpecification classSpecification, int n, JRadioButton[] jRadioButtonArray) {
        if (jRadioButtonArray[0].isSelected()) {
            classSpecification.requiredSetAccessFlags |= n;
        } else if (jRadioButtonArray[1].isSelected()) {
            classSpecification.requiredUnsetAccessFlags |= n;
        }
    }
}

