/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import proguard.ClassMemberSpecification;
import proguard.classfile.util.ClassUtil;
import proguard.gui.ClassMemberSpecificationDialog;
import proguard.gui.GUIResources;
import proguard.gui.ListPanel;

class ClassMemberSpecificationsPanel
extends ListPanel {
    private ClassMemberSpecificationDialog fieldSpecificationDialog;
    private ClassMemberSpecificationDialog methodSpecificationDialog;

    public ClassMemberSpecificationsPanel(JDialog jDialog, boolean bl) {
        this.firstSelectionButton = bl ? 3 : 2;
        this.list.setCellRenderer(new MyListCellRenderer());
        this.fieldSpecificationDialog = new ClassMemberSpecificationDialog(jDialog, true);
        this.methodSpecificationDialog = new ClassMemberSpecificationDialog(jDialog, false);
        if (bl) {
            this.addAddFieldButton();
        }
        this.addAddMethodButton();
        this.addEditButton();
        this.addRemoveButton();
        this.addUpButton();
        this.addDownButton();
        this.enableSelectionButtons();
    }

    protected void addAddFieldButton() {
        JButton jButton = new JButton(GUIResources.getMessage("addField"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassMemberSpecificationsPanel.this.fieldSpecificationDialog.setClassMemberSpecification(new ClassMemberSpecification());
                int n = ClassMemberSpecificationsPanel.this.fieldSpecificationDialog.showDialog();
                if (n == 0) {
                    ClassMemberSpecificationsPanel.this.addElement(new MyClassMemberSpecificationWrapper(ClassMemberSpecificationsPanel.this.fieldSpecificationDialog.getClassMemberSpecification(), true));
                }
            }
        });
        this.addButton(jButton);
    }

    protected void addAddMethodButton() {
        JButton jButton = new JButton(GUIResources.getMessage("addMethod"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassMemberSpecificationsPanel.this.methodSpecificationDialog.setClassMemberSpecification(new ClassMemberSpecification());
                int n = ClassMemberSpecificationsPanel.this.methodSpecificationDialog.showDialog();
                if (n == 0) {
                    ClassMemberSpecificationsPanel.this.addElement(new MyClassMemberSpecificationWrapper(ClassMemberSpecificationsPanel.this.methodSpecificationDialog.getClassMemberSpecification(), false));
                }
            }
        });
        this.addButton(jButton);
    }

    protected void addEditButton() {
        JButton jButton = new JButton(GUIResources.getMessage("edit"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MyClassMemberSpecificationWrapper myClassMemberSpecificationWrapper = (MyClassMemberSpecificationWrapper)ClassMemberSpecificationsPanel.this.list.getSelectedValue();
                ClassMemberSpecificationDialog classMemberSpecificationDialog = myClassMemberSpecificationWrapper.isField ? ClassMemberSpecificationsPanel.this.fieldSpecificationDialog : ClassMemberSpecificationsPanel.this.methodSpecificationDialog;
                classMemberSpecificationDialog.setClassMemberSpecification(myClassMemberSpecificationWrapper.classMemberSpecification);
                int n = classMemberSpecificationDialog.showDialog();
                if (n == 0) {
                    myClassMemberSpecificationWrapper.classMemberSpecification = classMemberSpecificationDialog.getClassMemberSpecification();
                    ClassMemberSpecificationsPanel.this.setElementAt(myClassMemberSpecificationWrapper, ClassMemberSpecificationsPanel.this.list.getSelectedIndex());
                }
            }
        });
        this.addButton(jButton);
    }

    public void setClassMemberSpecifications(List list, List list2) {
        int n;
        this.listModel.clear();
        if (list != null) {
            for (n = 0; n < list.size(); ++n) {
                this.listModel.addElement(new MyClassMemberSpecificationWrapper((ClassMemberSpecification)list.get(n), true));
            }
        }
        if (list2 != null) {
            for (n = 0; n < list2.size(); ++n) {
                this.listModel.addElement(new MyClassMemberSpecificationWrapper((ClassMemberSpecification)list2.get(n), false));
            }
        }
        this.enableSelectionButtons();
    }

    public List getClassMemberSpecifications(boolean bl) {
        int n = this.listModel.size();
        if (n == 0) {
            return null;
        }
        ArrayList<ClassMemberSpecification> arrayList = new ArrayList<ClassMemberSpecification>(n);
        for (int i = 0; i < n; ++i) {
            MyClassMemberSpecificationWrapper myClassMemberSpecificationWrapper = (MyClassMemberSpecificationWrapper)this.listModel.get(i);
            if (myClassMemberSpecificationWrapper.isField != bl) continue;
            arrayList.add(myClassMemberSpecificationWrapper.classMemberSpecification);
        }
        return arrayList;
    }

    private static class MyClassMemberSpecificationWrapper {
        public ClassMemberSpecification classMemberSpecification;
        public boolean isField;

        public MyClassMemberSpecificationWrapper(ClassMemberSpecification classMemberSpecification, boolean bl) {
            this.classMemberSpecification = classMemberSpecification;
            this.isField = bl;
        }
    }

    private static class MyListCellRenderer
    implements ListCellRenderer {
        JLabel label = new JLabel();

        private MyListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            MyClassMemberSpecificationWrapper myClassMemberSpecificationWrapper = (MyClassMemberSpecificationWrapper)object;
            ClassMemberSpecification classMemberSpecification = myClassMemberSpecificationWrapper.classMemberSpecification;
            String string = classMemberSpecification.name;
            String string2 = classMemberSpecification.descriptor;
            if (string == null) {
                string = "*";
            }
            this.label.setText(myClassMemberSpecificationWrapper.isField ? (string2 == null ? "<fields>" : ClassUtil.externalFullFieldDescription((int)0, (String)string, (String)string2)) : (string2 == null ? "<methods>" : ClassUtil.externalFullMethodDescription((String)"<init>", (int)0, (String)string, (String)string2)));
            if (bl) {
                this.label.setBackground(jList.getSelectionBackground());
                this.label.setForeground(jList.getSelectionForeground());
            } else {
                this.label.setBackground(jList.getBackground());
                this.label.setForeground(jList.getForeground());
            }
            this.label.setOpaque(true);
            return this.label;
        }
    }
}

