/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import proguard.ClassMemberSpecification;
import proguard.classfile.util.ClassUtil;
import proguard.gui.GUIResources;
import proguard.util.ListUtil;

class ClassMemberSpecificationDialog
extends JDialog {
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    private boolean isField;
    private JRadioButton[] publicRadioButtons;
    private JRadioButton[] privateRadioButtons;
    private JRadioButton[] protectedRadioButtons;
    private JRadioButton[] staticRadioButtons;
    private JRadioButton[] finalRadioButtons;
    private JRadioButton[] volatileRadioButtons;
    private JRadioButton[] transientRadioButtons;
    private JRadioButton[] synchronizedRadioButtons;
    private JRadioButton[] nativeRadioButtons;
    private JRadioButton[] abstractRadioButtons;
    private JRadioButton[] strictRadioButtons;
    private JTextField nameTextField = new JTextField(20);
    private JTextField typeTextField = new JTextField(20);
    private JTextField argumentsTextField = new JTextField(20);
    private int returnValue;

    public ClassMemberSpecificationDialog(JDialog jDialog, boolean bl) {
        super((Dialog)jDialog, true);
        this.setResizable(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridwidth = 0;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridwidth = 0;
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 0.0;
        gridBagConstraints5.anchor = 18;
        gridBagConstraints5.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridwidth = 0;
        gridBagConstraints6.fill = 1;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.anchor = 18;
        gridBagConstraints6.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.anchor = 10;
        gridBagConstraints7.insets = new Insets(2, 10, 2, 10);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridwidth = 0;
        gridBagConstraints8.anchor = 10;
        gridBagConstraints8.insets = gridBagConstraints7.insets;
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.weightx = 1.0;
        gridBagConstraints9.weighty = 1.0;
        gridBagConstraints9.anchor = 14;
        gridBagConstraints9.insets = new Insets(4, 4, 8, 4);
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridwidth = 0;
        gridBagConstraints10.weighty = 1.0;
        gridBagConstraints10.anchor = 14;
        gridBagConstraints10.insets = gridBagConstraints9.insets;
        GridBagLayout gridBagLayout = new GridBagLayout();
        Border border = BorderFactory.createEtchedBorder(0);
        this.isField = bl;
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(BorderFactory.createTitledBorder(border, GUIResources.getMessage("access")));
        jPanel.add(Box.createGlue(), gridBagConstraints7);
        jPanel.add((Component)new JLabel(GUIResources.getMessage("required")), gridBagConstraints7);
        jPanel.add((Component)new JLabel(GUIResources.getMessage("not")), gridBagConstraints7);
        jPanel.add((Component)new JLabel(GUIResources.getMessage("dontCare")), gridBagConstraints7);
        jPanel.add(Box.createGlue(), gridBagConstraints4);
        this.publicRadioButtons = this.addRadioButtonTriplet("Public", jPanel);
        this.privateRadioButtons = this.addRadioButtonTriplet("Private", jPanel);
        this.protectedRadioButtons = this.addRadioButtonTriplet("Protected", jPanel);
        this.staticRadioButtons = this.addRadioButtonTriplet("Static", jPanel);
        this.finalRadioButtons = this.addRadioButtonTriplet("Final", jPanel);
        if (bl) {
            this.volatileRadioButtons = this.addRadioButtonTriplet("Volatile", jPanel);
            this.transientRadioButtons = this.addRadioButtonTriplet("Transient", jPanel);
        } else {
            this.synchronizedRadioButtons = this.addRadioButtonTriplet("Synchronized", jPanel);
            this.nativeRadioButtons = this.addRadioButtonTriplet("Native", jPanel);
            this.abstractRadioButtons = this.addRadioButtonTriplet("Abstract", jPanel);
            this.strictRadioButtons = this.addRadioButtonTriplet("Strict", jPanel);
        }
        JPanel jPanel2 = new JPanel(gridBagLayout);
        jPanel2.setBorder(BorderFactory.createTitledBorder(border, GUIResources.getMessage(bl ? "type" : "returnType")));
        jPanel2.add((Component)this.typeTextField, gridBagConstraints4);
        JPanel jPanel3 = new JPanel(gridBagLayout);
        jPanel3.setBorder(BorderFactory.createTitledBorder(border, GUIResources.getMessage("name")));
        jPanel3.add((Component)this.nameTextField, gridBagConstraints4);
        JPanel jPanel4 = new JPanel(gridBagLayout);
        jPanel4.setBorder(BorderFactory.createTitledBorder(border, GUIResources.getMessage("arguments")));
        jPanel4.add((Component)this.argumentsTextField, gridBagConstraints4);
        JButton jButton = new JButton(GUIResources.getMessage("ok"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassMemberSpecificationDialog.this.returnValue = 0;
                ClassMemberSpecificationDialog.this.hide();
            }
        });
        JButton jButton2 = new JButton(GUIResources.getMessage("cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassMemberSpecificationDialog.this.hide();
            }
        });
        JPanel jPanel5 = new JPanel(gridBagLayout);
        jPanel5.add((Component)jPanel, gridBagConstraints5);
        jPanel5.add((Component)jPanel2, gridBagConstraints5);
        jPanel5.add((Component)jPanel3, gridBagConstraints5);
        if (!bl) {
            jPanel5.add((Component)jPanel4, gridBagConstraints5);
        }
        jPanel5.add((Component)jButton, gridBagConstraints9);
        jPanel5.add((Component)jButton2, gridBagConstraints10);
        this.getContentPane().add(jPanel5);
    }

    private JRadioButton[] addRadioButtonTriplet(String string, JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.weightx = 1.0;
        JRadioButton jRadioButton = new JRadioButton();
        JRadioButton jRadioButton2 = new JRadioButton();
        JRadioButton jRadioButton3 = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        jPanel.add((Component)new JLabel(string), gridBagConstraints);
        jPanel.add((Component)jRadioButton, gridBagConstraints2);
        jPanel.add((Component)jRadioButton2, gridBagConstraints2);
        jPanel.add((Component)jRadioButton3, gridBagConstraints2);
        jPanel.add(Box.createGlue(), gridBagConstraints3);
        return new JRadioButton[]{jRadioButton, jRadioButton2, jRadioButton3};
    }

    public void setClassMemberSpecification(ClassMemberSpecification classMemberSpecification) {
        String string = classMemberSpecification.name;
        String string2 = classMemberSpecification.descriptor;
        this.setClassMemberSpecificationRadioButtons(classMemberSpecification, 1, this.publicRadioButtons);
        this.setClassMemberSpecificationRadioButtons(classMemberSpecification, 2, this.privateRadioButtons);
        this.setClassMemberSpecificationRadioButtons(classMemberSpecification, 4, this.protectedRadioButtons);
        this.setClassMemberSpecificationRadioButtons(classMemberSpecification, 8, this.staticRadioButtons);
        this.setClassMemberSpecificationRadioButtons(classMemberSpecification, 16, this.finalRadioButtons);
        this.setClassMemberSpecificationRadioButtons(classMemberSpecification, 64, this.volatileRadioButtons);
        this.setClassMemberSpecificationRadioButtons(classMemberSpecification, 128, this.transientRadioButtons);
        this.setClassMemberSpecificationRadioButtons(classMemberSpecification, 32, this.synchronizedRadioButtons);
        this.setClassMemberSpecificationRadioButtons(classMemberSpecification, 256, this.nativeRadioButtons);
        this.setClassMemberSpecificationRadioButtons(classMemberSpecification, 1024, this.abstractRadioButtons);
        this.setClassMemberSpecificationRadioButtons(classMemberSpecification, 2048, this.strictRadioButtons);
        this.nameTextField.setText(string == null ? "" : string);
        if (this.isField) {
            this.typeTextField.setText(string2 == null ? "" : ClassUtil.externalType((String)string2));
        } else {
            this.typeTextField.setText(string2 == null ? "" : ClassUtil.externalMethodReturnType((String)string2));
            this.argumentsTextField.setText(string2 == null ? "" : ClassUtil.externalMethodArguments((String)string2));
        }
    }

    public ClassMemberSpecification getClassMemberSpecification() {
        String string = this.nameTextField.getText();
        String string2 = this.typeTextField.getText();
        String string3 = this.argumentsTextField.getText();
        if (string.equals("") || string.equals("*")) {
            string = null;
        }
        if (string2.equals("") || string2.equals("*")) {
            string2 = null;
        }
        if (string != null || string2 != null) {
            if (this.isField) {
                if (string2 == null) {
                    string2 = "int";
                }
                string2 = ClassUtil.internalType((String)string2);
            } else {
                if (string2 == null) {
                    string2 = "void";
                }
                string2 = ClassUtil.internalMethodDescriptor((String)string2, (List)ListUtil.commaSeparatedList((String)string3));
            }
        }
        ClassMemberSpecification classMemberSpecification = new ClassMemberSpecification(0, 0, string, string2);
        this.getClassMemberSpecificationRadioButtons(classMemberSpecification, 1, this.publicRadioButtons);
        this.getClassMemberSpecificationRadioButtons(classMemberSpecification, 2, this.privateRadioButtons);
        this.getClassMemberSpecificationRadioButtons(classMemberSpecification, 4, this.protectedRadioButtons);
        this.getClassMemberSpecificationRadioButtons(classMemberSpecification, 8, this.staticRadioButtons);
        this.getClassMemberSpecificationRadioButtons(classMemberSpecification, 16, this.finalRadioButtons);
        this.getClassMemberSpecificationRadioButtons(classMemberSpecification, 64, this.volatileRadioButtons);
        this.getClassMemberSpecificationRadioButtons(classMemberSpecification, 128, this.transientRadioButtons);
        this.getClassMemberSpecificationRadioButtons(classMemberSpecification, 32, this.synchronizedRadioButtons);
        this.getClassMemberSpecificationRadioButtons(classMemberSpecification, 256, this.nativeRadioButtons);
        this.getClassMemberSpecificationRadioButtons(classMemberSpecification, 1024, this.abstractRadioButtons);
        this.getClassMemberSpecificationRadioButtons(classMemberSpecification, 2048, this.strictRadioButtons);
        return classMemberSpecification;
    }

    public int showDialog() {
        this.returnValue = 1;
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.show();
        return this.returnValue;
    }

    private void setClassMemberSpecificationRadioButtons(ClassMemberSpecification classMemberSpecification, int n, JRadioButton[] jRadioButtonArray) {
        if (jRadioButtonArray != null) {
            int n2 = (classMemberSpecification.requiredSetAccessFlags & n) != 0 ? 0 : ((classMemberSpecification.requiredUnsetAccessFlags & n) != 0 ? 1 : 2);
            jRadioButtonArray[n2].setSelected(true);
        }
    }

    private void getClassMemberSpecificationRadioButtons(ClassMemberSpecification classMemberSpecification, int n, JRadioButton[] jRadioButtonArray) {
        if (jRadioButtonArray != null) {
            if (jRadioButtonArray[0].isSelected()) {
                classMemberSpecification.requiredSetAccessFlags |= n;
            } else if (jRadioButtonArray[1].isSelected()) {
                classMemberSpecification.requiredUnsetAccessFlags |= n;
            }
        }
    }
}

