/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.ClassFile;
import proguard.classfile.MethodInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionInfoVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.CpInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.optimize.evaluation.Processor;
import proguard.optimize.evaluation.TracedBranchUnit;
import proguard.optimize.evaluation.TracedStack;
import proguard.optimize.evaluation.TracedVariables;
import proguard.optimize.evaluation.UnusedParameterCleaner;
import proguard.optimize.evaluation.Variables;
import proguard.optimize.evaluation.value.InstructionOffsetValue;
import proguard.optimize.evaluation.value.InstructionOffsetValueFactory;
import proguard.optimize.evaluation.value.ReferenceValueFactory;
import proguard.optimize.evaluation.value.Value;
import proguard.optimize.peephole.BranchTargetFinder;

public class PartialEvaluator
implements ExceptionInfoVisitor,
InstructionVisitor {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_RESULTS = false;
    private static final int INITIAL_CODE_LENGTH = 1024;
    private static final int INITIAL_VALUE_COUNT = 32;
    public static final int AT_METHOD_ENTRY = -1;
    public static final int AT_CATCH_ENTRY = -1;
    public static final int NONE = -1;
    private BranchTargetFinder branchTargetFinder = new BranchTargetFinder(1024);
    private InstructionOffsetValue[] varProducerValues = new InstructionOffsetValue[1024];
    private InstructionOffsetValue[] stackProducerValues = new InstructionOffsetValue[1024];
    private InstructionOffsetValue[] unusedProducerValues = new InstructionOffsetValue[1024];
    private InstructionOffsetValue[] branchOriginValues = new InstructionOffsetValue[1024];
    private InstructionOffsetValue[] branchTargetValues = new InstructionOffsetValue[1024];
    private TracedVariables[] vars = new TracedVariables[1024];
    private TracedStack[] stacks = new TracedStack[1024];
    private int[] evaluationCounts = new int[1024];
    private int[] initializedVariables = new int[1024];
    private boolean evaluateExceptions;
    private TracedVariables variables = new TracedVariables(32);
    private TracedStack stack = new TracedStack(32);
    private TracedBranchUnit branchUnit = new TracedBranchUnit();

    public Value evaluate(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, Variables variables) {
        this.initializeVariables(codeAttrInfo, variables);
        codeAttrInfo.accept(classFile, methodInfo, (AttrInfoVisitor)this.branchTargetFinder);
        this.evaluateInstructionBlock(classFile, methodInfo, codeAttrInfo, this.variables, this.stack, this.branchUnit, 0);
        do {
            this.evaluateExceptions = false;
            codeAttrInfo.exceptionsAccept(classFile, methodInfo, this);
        } while (this.evaluateExceptions);
        codeAttrInfo.instructionsAccept(classFile, methodInfo, this);
        return this.branchUnit.getTraceReturnValue();
    }

    public boolean isTraced(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!this.isTraced(i)) continue;
            return true;
        }
        return false;
    }

    public boolean isTraced(int n) {
        return this.evaluationCounts[n] > 0;
    }

    public Value variableValue(int n, int n2) {
        return this.vars[n].load(n2);
    }

    public InstructionOffsetValue variableProducerOffsets(int n, int n2) {
        return this.vars[n].getStoredTraceValue(n2).instructionOffsetValue();
    }

    public InstructionOffsetValue varProducerOffsets(int n) {
        return this.varProducerValues[n];
    }

    public Value stackTopValue(int n, int n2) {
        return this.stacks[n].getTop(n2);
    }

    public InstructionOffsetValue stackTopProducerOffsets(int n, int n2) {
        return this.stacks[n].getTopProducerValue(n2).instructionOffsetValue();
    }

    public InstructionOffsetValue stackProducerOffsets(int n) {
        return this.stackProducerValues[n];
    }

    public InstructionOffsetValue stackTopConsumerOffsets(int n, int n2) {
        return this.stacks[n].getTopConsumerValue(n2).instructionOffsetValue();
    }

    public InstructionOffsetValue unusedProducerOffsets(int n) {
        return this.unusedProducerValues[n];
    }

    public InstructionOffsetValue branchOrigins(int n) {
        return this.branchOriginValues[n];
    }

    public InstructionOffsetValue branchTargets(int n) {
        return this.branchTargetValues[n];
    }

    public int initializedVariable(int n) {
        return this.initializedVariables[n];
    }

    public void visitExceptionInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, ExceptionInfo exceptionInfo) {
        if (this.isTraced(exceptionInfo.u2startpc, exceptionInfo.u2endpc)) {
            this.variables.reset(codeAttrInfo.u2maxLocals);
            this.generalizeVariables(exceptionInfo.u2startpc, exceptionInfo.u2endpc, this.variables);
            TracedVariables tracedVariables = (TracedVariables)exceptionInfo.getVisitorInfo();
            if (tracedVariables == null) {
                tracedVariables = new TracedVariables(codeAttrInfo.u2maxLocals);
                exceptionInfo.setVisitorInfo(tracedVariables);
            } else if (tracedVariables.equals(this.variables)) {
                return;
            }
            tracedVariables.initialize(this.variables);
            this.variables.reset(codeAttrInfo.u2maxLocals);
            this.stack.reset(codeAttrInfo.u2maxStack);
            InstructionOffsetValue instructionOffsetValue = InstructionOffsetValueFactory.create(-1);
            this.variables.setProducerValue(instructionOffsetValue);
            this.stack.setProducerValue(instructionOffsetValue);
            this.variables.initialize(tracedVariables);
            this.stack.push(ReferenceValueFactory.create(false));
            this.evaluateInstructionBlock(classFile, methodInfo, codeAttrInfo, this.variables, this.stack, this.branchUnit, exceptionInfo.u2handlerpc);
            this.evaluateExceptions = true;
        }
    }

    public void visitSimpleInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, SimpleInstruction simpleInstruction) {
    }

    public void visitVariableInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, VariableInstruction variableInstruction) {
    }

    public void visitBranchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, BranchInstruction branchInstruction) {
    }

    public void visitTableSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, TableSwitchInstruction tableSwitchInstruction) {
    }

    public void visitLookUpSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
    }

    public void visitCpInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, CpInstruction cpInstruction) {
        if (this.isTraced(n) && this.branchTargetFinder.isInitializer(n)) {
            int n2 = n - 1;
            while (!this.isTraced(n2)) {
                --n2;
            }
            int n3 = this.stacks[n].size();
            int n4 = this.stacks[n2].getBottomProducerValue(n3).instructionOffsetValue().instructionOffset(0);
            this.stackProducerValues[n4] = this.stackProducerValues[n4].generalize(InstructionOffsetValueFactory.create(n)).instructionOffsetValue();
        }
    }

    private void evaluateInstructionBlock(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, TracedVariables tracedVariables, TracedStack tracedStack, TracedBranchUnit tracedBranchUnit, int n) {
        byte[] byArray = codeAttrInfo.code;
        Processor processor = new Processor(tracedVariables, tracedStack, tracedBranchUnit);
        UnusedParameterCleaner unusedParameterCleaner = new UnusedParameterCleaner(tracedStack);
        while (true) {
            int n2;
            int n3;
            int n4 = n;
            this.evaluationCounts[n4] = this.evaluationCounts[n4] + 1;
            if (n3 == 0) {
                this.varProducerValues[n] = InstructionOffsetValueFactory.create();
                this.stackProducerValues[n] = InstructionOffsetValueFactory.create();
                this.unusedProducerValues[n] = InstructionOffsetValueFactory.create();
            }
            InstructionOffsetValue instructionOffsetValue = InstructionOffsetValueFactory.create(n);
            tracedVariables.setProducerValue(instructionOffsetValue);
            tracedStack.setProducerValue(instructionOffsetValue);
            InstructionOffsetValue instructionOffsetValue2 = InstructionOffsetValueFactory.create();
            tracedVariables.setCollectedProducerValue(instructionOffsetValue2);
            tracedStack.setCollectedProducerValue(instructionOffsetValue2);
            unusedParameterCleaner.setTraceValue(instructionOffsetValue2);
            tracedVariables.resetInitialization();
            Instruction instruction = InstructionFactory.create(byArray, n);
            int n5 = n + instruction.length(n);
            InstructionOffsetValue instructionOffsetValue3 = InstructionOffsetValueFactory.create(n5);
            tracedBranchUnit.resetCalled();
            tracedBranchUnit.setTraceBranchTargets(instructionOffsetValue3);
            instruction.accept(classFile, methodInfo, codeAttrInfo, n, unusedParameterCleaner);
            try {
                instruction.accept(classFile, methodInfo, codeAttrInfo, n, processor);
            }
            catch (RuntimeException runtimeException) {
                System.err.println("Unexpected error while performing partial evaluation:");
                System.err.println("  ClassFile   = [" + classFile.getName() + "]");
                System.err.println("  Method      = [" + methodInfo.getName(classFile) + methodInfo.getDescriptor(classFile) + "]");
                System.err.println("  Instruction = " + instruction.toString(n));
                throw runtimeException;
            }
            InstructionOffsetValue instructionOffsetValue4 = tracedVariables.getCollectedProducerValue().instructionOffsetValue();
            InstructionOffsetValue instructionOffsetValue5 = tracedStack.getCollectedProducerValue().instructionOffsetValue();
            InstructionOffsetValue instructionOffsetValue6 = unusedParameterCleaner.getTraceValue().instructionOffsetValue();
            this.varProducerValues[n] = this.varProducerValues[n].generalize(instructionOffsetValue4).instructionOffsetValue();
            this.stackProducerValues[n] = this.stackProducerValues[n].generalize(instructionOffsetValue5).instructionOffsetValue();
            this.unusedProducerValues[n] = this.unusedProducerValues[n].generalize(instructionOffsetValue6).instructionOffsetValue();
            this.initializedVariables[n] = tracedVariables.getInitializationIndex();
            InstructionOffsetValue instructionOffsetValue7 = tracedBranchUnit.getTraceBranchTargets();
            int n6 = instructionOffsetValue7.instructionOffsetCount();
            tracedVariables.setCollectedProducerValue(instructionOffsetValue2);
            tracedStack.setCollectedProducerValue(instructionOffsetValue2);
            tracedBranchUnit.setTraceBranchTargets(instructionOffsetValue2);
            if (this.vars[n] == null) {
                this.vars[n] = new TracedVariables(tracedVariables);
                this.stacks[n] = new TracedStack(tracedStack);
            } else if (n3 == 0) {
                this.vars[n].initialize(tracedVariables);
                this.stacks[n].copy(tracedStack);
            } else {
                boolean bl = this.vars[n].generalize(tracedVariables);
                n2 = this.stacks[n].generalize(tracedStack);
                if (!bl && n2 == 0 && instructionOffsetValue7.equals(this.branchTargetValues[n])) break;
                tracedVariables.initialize(this.vars[n]);
                tracedStack.copy(this.stacks[n]);
            }
            if (tracedBranchUnit.wasCalled()) {
                InstructionOffsetValue instructionOffsetValue8 = this.branchTargetValues[n] = this.branchTargetValues[n] == null ? instructionOffsetValue7 : this.branchTargetValues[n].generalize(instructionOffsetValue7).instructionOffsetValue();
                if (n6 == 0) break;
                InstructionOffsetValue instructionOffsetValue9 = InstructionOffsetValueFactory.create(n);
                for (n2 = 0; n2 < n6; ++n2) {
                    int n7 = instructionOffsetValue7.instructionOffset(n2);
                    this.branchOriginValues[n7] = this.branchOriginValues[n7] == null ? instructionOffsetValue9 : this.branchOriginValues[n7].generalize(instructionOffsetValue9).instructionOffsetValue();
                }
                if (n6 > 1) {
                    for (n2 = 0; n2 < n6; ++n2) {
                        this.evaluateInstructionBlock(classFile, methodInfo, codeAttrInfo, new TracedVariables(tracedVariables), new TracedStack(tracedStack), tracedBranchUnit, instructionOffsetValue7.instructionOffset(n2));
                    }
                    break;
                }
            }
            n = instructionOffsetValue7.instructionOffset(0);
        }
    }

    private void initializeVariables(CodeAttrInfo codeAttrInfo, Variables variables) {
        int n;
        int n2 = codeAttrInfo.u4codeLength;
        if (this.vars.length < n2) {
            this.varProducerValues = new InstructionOffsetValue[n2];
            this.stackProducerValues = new InstructionOffsetValue[n2];
            this.unusedProducerValues = new InstructionOffsetValue[n2];
            this.branchOriginValues = new InstructionOffsetValue[n2];
            this.branchTargetValues = new InstructionOffsetValue[n2];
            this.vars = new TracedVariables[n2];
            this.stacks = new TracedStack[n2];
            this.evaluationCounts = new int[n2];
            this.initializedVariables = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.initializedVariables[n] = -1;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                this.varProducerValues[n] = null;
                this.stackProducerValues[n] = null;
                this.unusedProducerValues[n] = null;
                this.branchOriginValues[n] = null;
                this.branchTargetValues[n] = null;
                this.evaluationCounts[n] = 0;
                this.initializedVariables[n] = -1;
                if (this.vars[n] != null) {
                    this.vars[n].reset(codeAttrInfo.u2maxLocals);
                }
                if (this.stacks[n] == null) continue;
                this.stacks[n].reset(codeAttrInfo.u2maxStack);
            }
        }
        this.variables.reset(codeAttrInfo.u2maxLocals);
        this.stack.reset(codeAttrInfo.u2maxStack);
        this.variables.initialize(variables);
        InstructionOffsetValue instructionOffsetValue = InstructionOffsetValueFactory.create(-1);
        for (int i = 0; i < variables.size(); ++i) {
            this.variables.setStoredTraceValue(i, instructionOffsetValue);
        }
        this.branchUnit.setTraceReturnValue(null);
    }

    private void generalizeVariables(int n, int n2, TracedVariables tracedVariables) {
        for (int i = n; i < n2; ++i) {
            if (!this.isTraced(i)) continue;
            tracedVariables.generalize(this.vars[i]);
        }
    }
}

