/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.optimize.MethodOptimizationInfo;

public class NoSideEffectMethodMarker
implements MemberInfoVisitor {
    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        NoSideEffectMethodMarker.markNoSideEffects(programMethodInfo);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        NoSideEffectMethodMarker.markNoSideEffects(libraryMethodInfo);
    }

    public static void markNoSideEffects(MethodInfo methodInfo) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(methodInfo);
        if (methodOptimizationInfo != null) {
            methodOptimizationInfo.setNoSideEffects();
        }
    }

    public static boolean hasNoSideEffects(MethodInfo methodInfo) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(methodInfo);
        return methodOptimizationInfo != null && methodOptimizationInfo.hasNoSideEffects();
    }
}

