/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.ClassFile;
import proguard.classfile.ClassPool;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassFileVisitor;

public class ClassPoolFiller
implements ClassFileVisitor {
    private ClassPool classPool;
    private boolean note;

    public ClassPoolFiller(ClassPool classPool, boolean bl) {
        this.classPool = classPool;
        this.note = bl;
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        ClassFile classFile = this.classPool.addClass(programClassFile);
        if (classFile != null && this.note) {
            System.err.println("Note: duplicate definition of program class [" + ClassUtil.externalClassName(programClassFile.getName()) + "]");
        }
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        ClassFile classFile = this.classPool.addClass(libraryClassFile);
        if (classFile != null && this.note) {
            System.err.println("Note: duplicate definition of library class [" + ClassUtil.externalClassName(libraryClassFile.getName()) + "]");
        }
    }
}

