/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import java.util.HashMap;
import java.util.Map;
import proguard.classfile.ClassFile;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMemberInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.visitor.AllMemberInfoVisitor;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;

public class MethodInfoLinker
implements ClassFileVisitor,
MemberInfoVisitor {
    private final Map methodInfoMap = new HashMap();

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        programClassFile.hierarchyAccept(true, true, true, false, new AllMemberInfoVisitor(this));
        this.methodInfoMap.clear();
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        this.visitMethodInfo(programClassFile, programMethodInfo);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        this.visitMethodInfo(libraryClassFile, libraryMethodInfo);
    }

    private void visitMethodInfo(ClassFile classFile, MethodInfo methodInfo) {
        if ((methodInfo.getAccessFlags() & 2) != 0) {
            return;
        }
        String string = methodInfo.getName(classFile);
        String string2 = methodInfo.getDescriptor(classFile);
        if (string.equals("<clinit>") || string.equals("<init>")) {
            return;
        }
        MethodInfo methodInfo2 = MethodInfoLinker.lastMethodInfo(methodInfo);
        String string3 = string + string2;
        MethodInfo methodInfo3 = (MethodInfo)this.methodInfoMap.get(string3);
        if (methodInfo3 == null) {
            this.methodInfoMap.put(string3, methodInfo2);
        } else {
            MethodInfo methodInfo4 = MethodInfoLinker.lastMethodInfo(methodInfo3);
            if (!methodInfo2.equals(methodInfo4)) {
                if (methodInfo4 instanceof LibraryMemberInfo) {
                    methodInfo2.setVisitorInfo(methodInfo4);
                } else {
                    methodInfo4.setVisitorInfo(methodInfo2);
                }
            }
        }
    }

    public static MethodInfo lastMethodInfo(MethodInfo methodInfo) {
        MethodInfo methodInfo2 = methodInfo;
        while (methodInfo2.getVisitorInfo() != null && methodInfo2.getVisitorInfo() instanceof MethodInfo) {
            methodInfo2 = (MethodInfo)methodInfo2.getVisitorInfo();
        }
        return methodInfo2;
    }

    public static VisitorAccepter lastVisitorAccepter(VisitorAccepter visitorAccepter) {
        VisitorAccepter visitorAccepter2 = visitorAccepter;
        while (visitorAccepter2.getVisitorInfo() != null && visitorAccepter2.getVisitorInfo() instanceof VisitorAccepter) {
            visitorAccepter2 = (VisitorAccepter)visitorAccepter2.getVisitorInfo();
        }
        return visitorAccepter2;
    }
}

