/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.CpInfo;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MemberInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.RefCpInfo;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ConstantValueAttrInfo;
import proguard.classfile.attribute.DeprecatedAttrInfo;
import proguard.classfile.attribute.EnclosingMethodAttrInfo;
import proguard.classfile.attribute.ExceptionsAttrInfo;
import proguard.classfile.attribute.InnerClassesAttrInfo;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttrInfo;
import proguard.classfile.attribute.SignatureAttrInfo;
import proguard.classfile.attribute.SourceDirAttrInfo;
import proguard.classfile.attribute.SourceFileAttrInfo;
import proguard.classfile.attribute.SyntheticAttrInfo;
import proguard.classfile.attribute.UnknownAttrInfo;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttrInfo;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationVisitor;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.ElementValueVisitor;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttrInfo;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.StackSizeUpdater;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.CpInfoVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;

public class MemberReferenceFixer
implements ClassFileVisitor,
CpInfoVisitor,
MemberInfoVisitor,
AttrInfoVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private static final boolean DEBUG = false;
    private ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor();
    private StackSizeUpdater stackSizeUpdater;
    private int cpIndex;
    private boolean isInterfaceMethod;
    private boolean stackSizesMayHaveChanged;

    public MemberReferenceFixer(int n) {
        this.stackSizeUpdater = new StackSizeUpdater(n);
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        this.stackSizesMayHaveChanged = false;
        for (int i = 1; i < programClassFile.u2constantPoolCount; ++i) {
            CpInfo cpInfo = programClassFile.constantPool[i];
            if (cpInfo == null) continue;
            this.cpIndex = i;
            cpInfo.accept(programClassFile, this);
        }
        programClassFile.fieldsAccept(this);
        programClassFile.methodsAccept(this);
        programClassFile.attributesAccept(this);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
        MemberInfo memberInfo = fieldrefCpInfo.referencedMemberInfo;
        if (memberInfo != null) {
            ClassFile classFile2 = fieldrefCpInfo.referencedClassFile;
            String string = memberInfo.getName(classFile2);
            String string2 = memberInfo.getDescriptor(classFile2);
            if (!fieldrefCpInfo.getName(classFile).equals(string) || !fieldrefCpInfo.getType(classFile).equals(string2)) {
                fieldrefCpInfo.u2nameAndTypeIndex = this.constantPoolEditor.addNameAndTypeCpInfo((ProgramClassFile)classFile, string, string2);
            }
        }
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
        MemberInfo memberInfo = interfaceMethodrefCpInfo.referencedMemberInfo;
        if (memberInfo != null) {
            ClassFile classFile2 = interfaceMethodrefCpInfo.referencedClassFile;
            String string = memberInfo.getName(classFile2);
            String string2 = memberInfo.getDescriptor(classFile2);
            if (!interfaceMethodrefCpInfo.getName(classFile).equals(string) || !interfaceMethodrefCpInfo.getType(classFile).equals(string2)) {
                interfaceMethodrefCpInfo.u2nameAndTypeIndex = this.constantPoolEditor.addNameAndTypeCpInfo((ProgramClassFile)classFile, string, string2);
                this.stackSizesMayHaveChanged = true;
            }
            this.isInterfaceMethod = true;
            classFile.constantPoolEntryAccept(interfaceMethodrefCpInfo.u2classIndex, this);
            if (!this.isInterfaceMethod) {
                ((ProgramClassFile)classFile).constantPool[this.cpIndex] = new MethodrefCpInfo(interfaceMethodrefCpInfo.u2classIndex, interfaceMethodrefCpInfo.u2nameAndTypeIndex, classFile2, memberInfo);
            }
        }
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
        MemberInfo memberInfo = methodrefCpInfo.referencedMemberInfo;
        if (memberInfo != null) {
            ClassFile classFile2 = methodrefCpInfo.referencedClassFile;
            String string = memberInfo.getName(classFile2);
            String string2 = memberInfo.getDescriptor(classFile2);
            if (!methodrefCpInfo.getName(classFile).equals(string) || !methodrefCpInfo.getType(classFile).equals(string2)) {
                methodrefCpInfo.u2nameAndTypeIndex = this.constantPoolEditor.addNameAndTypeCpInfo((ProgramClassFile)classFile, string, string2);
                this.stackSizesMayHaveChanged = true;
            }
            this.isInterfaceMethod = false;
            classFile.constantPoolEntryAccept(methodrefCpInfo.u2classIndex, this);
            if (this.isInterfaceMethod) {
                ((ProgramClassFile)classFile).constantPool[this.cpIndex] = new InterfaceMethodrefCpInfo(methodrefCpInfo.u2classIndex, methodrefCpInfo.u2nameAndTypeIndex, classFile2, memberInfo);
            }
        }
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
        ClassFile classFile2 = classCpInfo.referencedClassFile;
        if (classFile2 != null) {
            this.isInterfaceMethod = (classFile2.getAccessFlags() & 0x200) != 0;
        }
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        programFieldInfo.attributesAccept(programClassFile, this);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        programMethodInfo.attributesAccept(programClassFile, this);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
    }

    public void visitUnknownAttrInfo(ClassFile classFile, UnknownAttrInfo unknownAttrInfo) {
    }

    public void visitInnerClassesAttrInfo(ClassFile classFile, InnerClassesAttrInfo innerClassesAttrInfo) {
    }

    public void visitConstantValueAttrInfo(ClassFile classFile, FieldInfo fieldInfo, ConstantValueAttrInfo constantValueAttrInfo) {
    }

    public void visitExceptionsAttrInfo(ClassFile classFile, MethodInfo methodInfo, ExceptionsAttrInfo exceptionsAttrInfo) {
    }

    public void visitLineNumberTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberTableAttrInfo lineNumberTableAttrInfo) {
    }

    public void visitLocalVariableTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTableAttrInfo localVariableTableAttrInfo) {
    }

    public void visitLocalVariableTypeTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeTableAttrInfo localVariableTypeTableAttrInfo) {
    }

    public void visitSourceFileAttrInfo(ClassFile classFile, SourceFileAttrInfo sourceFileAttrInfo) {
    }

    public void visitSourceDirAttrInfo(ClassFile classFile, SourceDirAttrInfo sourceDirAttrInfo) {
    }

    public void visitDeprecatedAttrInfo(ClassFile classFile, DeprecatedAttrInfo deprecatedAttrInfo) {
    }

    public void visitSyntheticAttrInfo(ClassFile classFile, SyntheticAttrInfo syntheticAttrInfo) {
    }

    public void visitSignatureAttrInfo(ClassFile classFile, SignatureAttrInfo signatureAttrInfo) {
    }

    public void visitEnclosingMethodAttrInfo(ClassFile classFile, EnclosingMethodAttrInfo enclosingMethodAttrInfo) {
        MethodInfo methodInfo = enclosingMethodAttrInfo.referencedMethodInfo;
        if (methodInfo != null) {
            ClassFile classFile2 = enclosingMethodAttrInfo.referencedClassFile;
            if (!enclosingMethodAttrInfo.getClassName(classFile).equals(classFile2.getName())) {
                enclosingMethodAttrInfo.u2classIndex = this.constantPoolEditor.addClassCpInfo((ProgramClassFile)classFile, classFile2);
            }
            if (!enclosingMethodAttrInfo.getName(classFile).equals(methodInfo.getName(classFile2)) || !enclosingMethodAttrInfo.getType(classFile).equals(methodInfo.getDescriptor(classFile2))) {
                enclosingMethodAttrInfo.u2nameAndTypeIndex = this.constantPoolEditor.addNameAndTypeCpInfo((ProgramClassFile)classFile, methodInfo.getName(classFile2), methodInfo.getDescriptor(classFile2));
            }
        }
    }

    public void visitCodeAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
        if (this.stackSizesMayHaveChanged) {
            this.stackSizeUpdater.visitCodeAttrInfo(classFile, methodInfo, codeAttrInfo);
        }
        codeAttrInfo.attributesAccept(classFile, methodInfo, this);
    }

    public void visitRuntimeVisibleAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleAnnotationsAttrInfo runtimeVisibleAnnotationsAttrInfo) {
        runtimeVisibleAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeInvisibleAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleAnnotationsAttrInfo runtimeInvisibleAnnotationsAttrInfo) {
        runtimeInvisibleAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeVisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleParameterAnnotationsAttrInfo runtimeVisibleParameterAnnotationsAttrInfo) {
        runtimeVisibleParameterAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeInvisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleParameterAnnotationsAttrInfo runtimeInvisibleParameterAnnotationsAttrInfo) {
        runtimeInvisibleParameterAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitAnnotationDefaultAttrInfo(ClassFile classFile, AnnotationDefaultAttrInfo annotationDefaultAttrInfo) {
        annotationDefaultAttrInfo.defaultValueAccept(classFile, this);
    }

    public void visitAnnotation(ClassFile classFile, Annotation annotation) {
        annotation.elementValuesAccept(classFile, this);
    }

    public void visitConstantElementValue(ClassFile classFile, Annotation annotation, ConstantElementValue constantElementValue) {
        this.fixElementValue(classFile, annotation, constantElementValue);
    }

    public void visitEnumConstantElementValue(ClassFile classFile, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        this.fixElementValue(classFile, annotation, enumConstantElementValue);
    }

    public void visitClassElementValue(ClassFile classFile, Annotation annotation, ClassElementValue classElementValue) {
        this.fixElementValue(classFile, annotation, classElementValue);
    }

    public void visitAnnotationElementValue(ClassFile classFile, Annotation annotation, AnnotationElementValue annotationElementValue) {
        this.fixElementValue(classFile, annotation, annotationElementValue);
        annotationElementValue.annotationAccept(classFile, this);
    }

    public void visitArrayElementValue(ClassFile classFile, Annotation annotation, ArrayElementValue arrayElementValue) {
        this.fixElementValue(classFile, annotation, arrayElementValue);
        arrayElementValue.elementValuesAccept(classFile, annotation, this);
    }

    private void fixElementValue(ClassFile classFile, Annotation annotation, ElementValue elementValue) {
        String string;
        String string2;
        MethodInfo methodInfo = elementValue.referencedMethodInfo;
        if (methodInfo != null && !(string2 = elementValue.getMethodName(classFile)).equals(string = methodInfo.getName(annotation.referencedClassFiles[0]))) {
            elementValue.u2elementName = this.constantPoolEditor.addUtf8CpInfo((ProgramClassFile)classFile, string);
        }
    }

    private void debug(ClassFile classFile, RefCpInfo refCpInfo, ClassFile classFile2, MemberInfo memberInfo) {
        System.out.println("MemberReferenceFixer:");
        System.out.println("  Class file      = " + classFile.getName());
        System.out.println("  Ref class file  = " + classFile2.getName());
        System.out.println("  Ref member name = " + refCpInfo.getName(classFile));
        System.out.println("                 -> " + memberInfo.getName(classFile2));
        System.out.println("  Ref descriptor  = " + refCpInfo.getType(classFile));
        System.out.println("                 -> " + memberInfo.getDescriptor(classFile2));
    }
}

