/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.ClassFile;
import proguard.classfile.CpInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.editor.ComparableCpInfo;
import proguard.classfile.editor.ConstantPoolRemapper;
import proguard.classfile.visitor.ClassFileVisitor;

public class ConstantPoolSorter
implements ClassFileVisitor {
    private int[] cpIndexMap;
    private ComparableCpInfo[] comparableConstantPool;
    private ConstantPoolRemapper constantPoolRemapper;

    public ConstantPoolSorter(int n) {
        this.constantPoolRemapper = new ConstantPoolRemapper(n);
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        this.sortConstantPool(programClassFile, programClassFile.constantPool, programClassFile.u2constantPoolCount);
        this.constantPoolRemapper.setCpIndexMap(this.cpIndexMap);
        this.constantPoolRemapper.visitProgramClassFile(programClassFile);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
    }

    private void sortConstantPool(ClassFile classFile, CpInfo[] cpInfoArray, int n) {
        if (this.cpIndexMap == null || this.cpIndexMap.length < n) {
            this.cpIndexMap = new int[n];
            this.comparableConstantPool = new ComparableCpInfo[n];
        }
        for (int i = 1; i < n; ++i) {
            CpInfo cpInfo = cpInfoArray[i];
            if (cpInfo == null) {
                cpInfo = cpInfoArray[i - 1];
            }
            this.comparableConstantPool[i] = new ComparableCpInfo(classFile, i, cpInfo);
        }
        Arrays.sort(this.comparableConstantPool, 1, n);
        CpInfo cpInfo = null;
        for (int i = 1; i < n; ++i) {
            ComparableCpInfo comparableCpInfo = this.comparableConstantPool[i];
            int n2 = comparableCpInfo.getIndex();
            this.cpIndexMap[n2] = i;
            CpInfo cpInfo2 = comparableCpInfo.getCpInfo();
            cpInfoArray[i] = cpInfo2 != cpInfo ? cpInfo2 : null;
            cpInfo = cpInfo2;
        }
    }
}

