/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.ClassFile;
import proguard.classfile.FieldInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ConstantValueAttrInfo;
import proguard.classfile.attribute.DeprecatedAttrInfo;
import proguard.classfile.attribute.EnclosingMethodAttrInfo;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionInfoVisitor;
import proguard.classfile.attribute.ExceptionsAttrInfo;
import proguard.classfile.attribute.InnerClassesAttrInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableInfoVisitor;
import proguard.classfile.attribute.LocalVariableTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeInfoVisitor;
import proguard.classfile.attribute.LocalVariableTypeTableAttrInfo;
import proguard.classfile.attribute.SignatureAttrInfo;
import proguard.classfile.attribute.SourceDirAttrInfo;
import proguard.classfile.attribute.SourceFileAttrInfo;
import proguard.classfile.attribute.SyntheticAttrInfo;
import proguard.classfile.attribute.UnknownAttrInfo;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttrInfo;
import proguard.classfile.editor.StackSizeUpdater;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.CpInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.visitor.LineNumberInfoVisitor;

public class CodeAttrInfoEditor
implements AttrInfoVisitor,
InstructionVisitor,
ExceptionInfoVisitor,
LineNumberInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor {
    private int codeLength;
    private boolean modified;
    private boolean inserted;
    public Instruction[] preInsertions;
    public Instruction[] replacements;
    public Instruction[] postInsertions;
    private boolean[] deleted;
    private int[] instructionOffsetMap;
    private StackSizeUpdater stackSizeUpdater;

    public CodeAttrInfoEditor(int n) {
        this.codeLength = n;
        this.preInsertions = new Instruction[n];
        this.replacements = new Instruction[n];
        this.postInsertions = new Instruction[n];
        this.deleted = new boolean[n];
        this.stackSizeUpdater = new StackSizeUpdater(n);
    }

    public void reset(int n) {
        this.codeLength = n;
        if (this.preInsertions.length < n) {
            this.preInsertions = new Instruction[n];
            this.replacements = new Instruction[n];
            this.postInsertions = new Instruction[n];
            this.deleted = new boolean[n];
        } else {
            for (int i = 0; i < n; ++i) {
                this.preInsertions[i] = null;
                this.replacements[i] = null;
                this.postInsertions[i] = null;
                this.deleted[i] = false;
            }
        }
        this.modified = false;
        this.inserted = false;
    }

    public void insertBeforeInstruction(int n, Instruction instruction) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        this.preInsertions[n] = instruction;
        this.modified = true;
        this.inserted = true;
    }

    public void replaceInstruction(int n, Instruction instruction) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        this.replacements[n] = instruction;
        this.modified = true;
    }

    public void insertAfterInstruction(int n, Instruction instruction) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        this.postInsertions[n] = instruction;
        this.modified = true;
        this.inserted = true;
    }

    public void deleteInstruction(int n) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        this.deleted[n] = true;
        this.modified = true;
        this.inserted = true;
    }

    public boolean isModified(int n) {
        return this.preInsertions[n] != null || this.replacements[n] != null || this.postInsertions[n] != null || this.deleted[n];
    }

    public boolean isModified() {
        return this.modified;
    }

    public void visitUnknownAttrInfo(ClassFile classFile, UnknownAttrInfo unknownAttrInfo) {
    }

    public void visitInnerClassesAttrInfo(ClassFile classFile, InnerClassesAttrInfo innerClassesAttrInfo) {
    }

    public void visitEnclosingMethodAttrInfo(ClassFile classFile, EnclosingMethodAttrInfo enclosingMethodAttrInfo) {
    }

    public void visitConstantValueAttrInfo(ClassFile classFile, FieldInfo fieldInfo, ConstantValueAttrInfo constantValueAttrInfo) {
    }

    public void visitExceptionsAttrInfo(ClassFile classFile, MethodInfo methodInfo, ExceptionsAttrInfo exceptionsAttrInfo) {
    }

    public void visitSourceFileAttrInfo(ClassFile classFile, SourceFileAttrInfo sourceFileAttrInfo) {
    }

    public void visitSourceDirAttrInfo(ClassFile classFile, SourceDirAttrInfo sourceDirAttrInfo) {
    }

    public void visitDeprecatedAttrInfo(ClassFile classFile, DeprecatedAttrInfo deprecatedAttrInfo) {
    }

    public void visitSyntheticAttrInfo(ClassFile classFile, SyntheticAttrInfo syntheticAttrInfo) {
    }

    public void visitSignatureAttrInfo(ClassFile classFile, SignatureAttrInfo signatureAttrInfo) {
    }

    public void visitRuntimeVisibleAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleAnnotationsAttrInfo runtimeVisibleAnnotationsAttrInfo) {
    }

    public void visitRuntimeInvisibleAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleAnnotationsAttrInfo runtimeInvisibleAnnotationsAttrInfo) {
    }

    public void visitRuntimeVisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleParameterAnnotationsAttrInfo runtimeVisibleParameterAnnotationsAttrInfo) {
    }

    public void visitRuntimeInvisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleParameterAnnotationsAttrInfo runtimeInvisibleParameterAnnotationsAttrInfo) {
    }

    public void visitAnnotationDefaultAttrInfo(ClassFile classFile, AnnotationDefaultAttrInfo annotationDefaultAttrInfo) {
    }

    public void visitCodeAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
        if (!this.modified) {
            return;
        }
        if (this.canPerformSimpleReplacements(codeAttrInfo)) {
            this.performSimpleReplacements(codeAttrInfo);
        } else {
            codeAttrInfo.u4codeLength = this.moveInstructions(classFile, methodInfo, codeAttrInfo);
            codeAttrInfo.exceptionsAccept(classFile, methodInfo, this);
            codeAttrInfo.attributesAccept(classFile, methodInfo, this);
            codeAttrInfo.u2exceptionTableLength = this.removeEmptyExceptions(codeAttrInfo.exceptionTable, codeAttrInfo.u2exceptionTableLength);
        }
        this.stackSizeUpdater.visitCodeAttrInfo(classFile, methodInfo, codeAttrInfo);
    }

    public void visitLineNumberTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberTableAttrInfo lineNumberTableAttrInfo) {
        lineNumberTableAttrInfo.lineNumbersAccept(classFile, methodInfo, codeAttrInfo, this);
        lineNumberTableAttrInfo.u2lineNumberTableLength = this.removeEmptyLineNumbers(lineNumberTableAttrInfo.lineNumberTable, lineNumberTableAttrInfo.u2lineNumberTableLength, codeAttrInfo.u4codeLength);
    }

    public void visitLocalVariableTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTableAttrInfo localVariableTableAttrInfo) {
        localVariableTableAttrInfo.localVariablesAccept(classFile, methodInfo, codeAttrInfo, this);
        localVariableTableAttrInfo.u2localVariableTableLength = this.removeEmptyLocalVariables(localVariableTableAttrInfo.localVariableTable, localVariableTableAttrInfo.u2localVariableTableLength);
    }

    public void visitLocalVariableTypeTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeTableAttrInfo localVariableTypeTableAttrInfo) {
        localVariableTypeTableAttrInfo.localVariablesAccept(classFile, methodInfo, codeAttrInfo, this);
        localVariableTypeTableAttrInfo.u2localVariableTypeTableLength = this.removeEmptyLocalVariableTypes(localVariableTypeTableAttrInfo.localVariableTypeTable, localVariableTypeTableAttrInfo.u2localVariableTypeTableLength);
    }

    public void visitSimpleInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, SimpleInstruction simpleInstruction) {
    }

    public void visitCpInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, CpInstruction cpInstruction) {
    }

    public void visitVariableInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, VariableInstruction variableInstruction) {
    }

    public void visitBranchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, BranchInstruction branchInstruction) {
        branchInstruction.branchOffset = this.remapBranchOffset(n, branchInstruction.branchOffset);
    }

    public void visitTableSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, TableSwitchInstruction tableSwitchInstruction) {
        tableSwitchInstruction.defaultOffset = this.remapBranchOffset(n, tableSwitchInstruction.defaultOffset);
        this.remapJumpOffsets(n, tableSwitchInstruction.jumpOffsets, tableSwitchInstruction.highCase - tableSwitchInstruction.lowCase + 1);
    }

    public void visitLookUpSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
        lookUpSwitchInstruction.defaultOffset = this.remapBranchOffset(n, lookUpSwitchInstruction.defaultOffset);
        this.remapJumpOffsets(n, lookUpSwitchInstruction.jumpOffsets, lookUpSwitchInstruction.jumpOffsetCount);
    }

    public void visitExceptionInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, ExceptionInfo exceptionInfo) {
        exceptionInfo.u2startpc = this.remapInstructionOffset(exceptionInfo.u2startpc);
        exceptionInfo.u2endpc = this.remapInstructionOffset(exceptionInfo.u2endpc);
        exceptionInfo.u2handlerpc = this.remapInstructionOffset(exceptionInfo.u2handlerpc);
    }

    public void visitLineNumberInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberInfo lineNumberInfo) {
        lineNumberInfo.u2startpc = this.remapInstructionOffset(lineNumberInfo.u2startpc);
    }

    public void visitLocalVariableInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableInfo localVariableInfo) {
        localVariableInfo.u2length = this.remapBranchOffset(localVariableInfo.u2startpc, localVariableInfo.u2length);
        localVariableInfo.u2startpc = this.remapInstructionOffset(localVariableInfo.u2startpc);
    }

    public void visitLocalVariableTypeInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeInfo localVariableTypeInfo) {
        localVariableTypeInfo.u2length = this.remapBranchOffset(localVariableTypeInfo.u2startpc, localVariableTypeInfo.u2length);
        localVariableTypeInfo.u2startpc = this.remapInstructionOffset(localVariableTypeInfo.u2startpc);
    }

    private boolean canPerformSimpleReplacements(CodeAttrInfo codeAttrInfo) {
        if (this.inserted) {
            return false;
        }
        byte[] byArray = codeAttrInfo.code;
        int n = codeAttrInfo.u4codeLength;
        for (int i = 0; i < n; ++i) {
            Instruction instruction = this.replacements[i];
            if (instruction == null || instruction.length(i) == InstructionFactory.create(byArray, i).length(i)) continue;
            return false;
        }
        return true;
    }

    private void performSimpleReplacements(CodeAttrInfo codeAttrInfo) {
        byte[] byArray = codeAttrInfo.code;
        int n = codeAttrInfo.u4codeLength;
        for (int i = 0; i < n; ++i) {
            Instruction instruction = this.replacements[i];
            if (instruction == null) continue;
            instruction.write(codeAttrInfo, i);
        }
    }

    private int moveInstructions(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
        Instruction instruction;
        byte[] byArray = codeAttrInfo.code;
        int n = codeAttrInfo.u4codeLength;
        if (this.instructionOffsetMap == null || this.instructionOffsetMap.length < n + 1) {
            this.instructionOffsetMap = new int[n + 1];
        }
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        do {
            if ((n3 = this.mapInstruction(instruction = InstructionFactory.create(byArray, n2), n2, n3)) <= (n2 += instruction.length(n2))) continue;
            bl = true;
        } while (n2 < n);
        this.instructionOffsetMap[n2] = n3;
        if (bl) {
            codeAttrInfo.code = new byte[n3];
        }
        n2 = 0;
        do {
            instruction = InstructionFactory.create(byArray, n2);
            this.moveInstruction(classFile, methodInfo, codeAttrInfo, n2, instruction);
        } while ((n2 += instruction.length(n2)) < n);
        return n3;
    }

    private int mapInstruction(Instruction instruction, int n, int n2) {
        Instruction instruction2;
        this.instructionOffsetMap[n] = n2;
        Instruction instruction3 = this.preInsertions[n];
        if (instruction3 != null) {
            n2 += instruction3.length(n2);
        }
        if ((instruction2 = this.replacements[n]) != null) {
            n2 += instruction2.length(n2);
        } else if (!this.deleted[n]) {
            n2 += instruction.length(n2);
        }
        Instruction instruction4 = this.postInsertions[n];
        if (instruction4 != null) {
            n2 += instruction4.length(n2);
        }
        return n2;
    }

    private void moveInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, Instruction instruction) {
        Instruction instruction2;
        int n2 = this.remapInstructionOffset(n);
        Instruction instruction3 = this.preInsertions[n];
        if (instruction3 != null) {
            instruction3.accept(classFile, methodInfo, codeAttrInfo, n, this);
            instruction3.write(codeAttrInfo, n2);
            n2 += instruction3.length(n2);
        }
        if ((instruction2 = this.replacements[n]) != null) {
            instruction2.accept(classFile, methodInfo, codeAttrInfo, n, this);
            instruction2.write(codeAttrInfo, n2);
            n2 += instruction2.length(n2);
        } else if (!this.deleted[n]) {
            instruction.accept(classFile, methodInfo, codeAttrInfo, n, this);
            instruction.write(codeAttrInfo, n2);
            n2 += instruction.length(n2);
        }
        Instruction instruction4 = this.postInsertions[n];
        if (instruction4 != null) {
            instruction4.accept(classFile, methodInfo, codeAttrInfo, n, this);
            instruction4.write(codeAttrInfo, n2);
        }
    }

    private void remapJumpOffsets(int n, int[] nArray, int n2) {
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.remapBranchOffset(n, nArray[i]);
        }
    }

    private int remapBranchOffset(int n, int n2) {
        return this.remapInstructionOffset(n + n2) - this.remapInstructionOffset(n);
    }

    private int remapInstructionOffset(int n) {
        if (n < 0 || n > this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        return this.instructionOffsetMap[n];
    }

    private int removeEmptyExceptions(ExceptionInfo[] exceptionInfoArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ExceptionInfo exceptionInfo = exceptionInfoArray[i];
            if (exceptionInfo.u2startpc >= exceptionInfo.u2endpc) continue;
            exceptionInfoArray[n2++] = exceptionInfo;
        }
        return n2;
    }

    private int removeEmptyLineNumbers(LineNumberInfo[] lineNumberInfoArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            LineNumberInfo lineNumberInfo = lineNumberInfoArray[i];
            int n4 = lineNumberInfo.u2startpc;
            if (n4 >= n2 || i != 0 && n4 <= lineNumberInfoArray[i - 1].u2startpc) continue;
            lineNumberInfoArray[n3++] = lineNumberInfo;
        }
        return n3;
    }

    private int removeEmptyLocalVariables(LocalVariableInfo[] localVariableInfoArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            LocalVariableInfo localVariableInfo = localVariableInfoArray[i];
            if (localVariableInfo.u2length <= 0) continue;
            localVariableInfoArray[n2++] = localVariableInfo;
        }
        return n2;
    }

    private int removeEmptyLocalVariableTypes(LocalVariableTypeInfo[] localVariableTypeInfoArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            LocalVariableTypeInfo localVariableTypeInfo = localVariableTypeInfoArray[i];
            if (localVariableTypeInfo.u2length <= 0) continue;
            localVariableTypeInfoArray[n2++] = localVariableTypeInfo;
        }
        return n2;
    }
}

