/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.visitor.CpInfoVisitor;

public abstract class CpInfo
implements VisitorAccepter {
    private static final IntegerCpInfo integerCpInfo = new IntegerCpInfo();
    private static final FloatCpInfo floatCpInfo = new FloatCpInfo();
    private static final LongCpInfo longCpInfo = new LongCpInfo();
    private static final DoubleCpInfo doubleCpInfo = new DoubleCpInfo();
    private static final StringCpInfo stringCpInfo = new StringCpInfo();
    private static final FieldrefCpInfo fieldrefCpInfo = new FieldrefCpInfo();
    private static final MethodrefCpInfo methodrefCpInfo = new MethodrefCpInfo();
    private static final InterfaceMethodrefCpInfo interfaceMethodrefCpInfo = new InterfaceMethodrefCpInfo();
    private static final NameAndTypeCpInfo nameAndTypeCpInfo = new NameAndTypeCpInfo();
    public Object visitorInfo;

    public static CpInfo create(DataInput dataInput) throws IOException {
        CpInfo cpInfo = null;
        int n = dataInput.readUnsignedByte();
        switch (n) {
            case 1: {
                cpInfo = new Utf8CpInfo();
                break;
            }
            case 3: {
                cpInfo = new IntegerCpInfo();
                break;
            }
            case 4: {
                cpInfo = new FloatCpInfo();
                break;
            }
            case 5: {
                cpInfo = new LongCpInfo();
                break;
            }
            case 6: {
                cpInfo = new DoubleCpInfo();
                break;
            }
            case 7: {
                cpInfo = new ClassCpInfo();
                break;
            }
            case 8: {
                cpInfo = new StringCpInfo();
                break;
            }
            case 9: {
                cpInfo = new FieldrefCpInfo();
                break;
            }
            case 10: {
                cpInfo = new MethodrefCpInfo();
                break;
            }
            case 11: {
                cpInfo = new InterfaceMethodrefCpInfo();
                break;
            }
            case 12: {
                cpInfo = new NameAndTypeCpInfo();
                break;
            }
            default: {
                throw new IOException("Unknown constant type [" + n + "] in constant pool");
            }
        }
        cpInfo.readInfo(dataInput);
        return cpInfo;
    }

    public static CpInfo createOrShare(DataInput dataInput) throws IOException {
        CpInfo cpInfo = null;
        int n = dataInput.readUnsignedByte();
        switch (n) {
            case 1: {
                cpInfo = new Utf8CpInfo();
                break;
            }
            case 3: {
                cpInfo = integerCpInfo;
                break;
            }
            case 4: {
                cpInfo = floatCpInfo;
                break;
            }
            case 5: {
                cpInfo = longCpInfo;
                break;
            }
            case 6: {
                cpInfo = doubleCpInfo;
                break;
            }
            case 7: {
                cpInfo = new ClassCpInfo();
                break;
            }
            case 8: {
                cpInfo = stringCpInfo;
                break;
            }
            case 9: {
                cpInfo = fieldrefCpInfo;
                break;
            }
            case 10: {
                cpInfo = methodrefCpInfo;
                break;
            }
            case 11: {
                cpInfo = interfaceMethodrefCpInfo;
                break;
            }
            case 12: {
                cpInfo = nameAndTypeCpInfo;
                break;
            }
            default: {
                throw new IOException("Unknown constant type [" + n + "] in constant pool");
            }
        }
        ((CpInfo)cpInfo).readInfo(dataInput);
        return cpInfo;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.getTag());
        this.writeInfo(dataOutput);
    }

    public abstract int getTag();

    protected abstract void readInfo(DataInput var1) throws IOException;

    protected abstract void writeInfo(DataOutput var1) throws IOException;

    public abstract void accept(ClassFile var1, CpInfoVisitor var2);

    public Object getVisitorInfo() {
        return this.visitorInfo;
    }

    public void setVisitorInfo(Object object) {
        this.visitorInfo = object;
    }
}

