
; Link this with FILE32, and ARGC32, and enable OPENFILE, READFILE,
; FILESIZE, CCHEKSTR, and CCHEKSWITCH in their respective libs.

        .386p
        jumps

code32  segment para public use32
        assume cs:code32, ds:code32, ss:code32

include pmode.inc
include file.inc
include argc.inc

public  _main

;
; DATA
;
errmsg0         db      'SYNTAX: TGA2ICON [-a#] filename',0dh,0ah,0dh,0ah
                db      '   -a add number to all numbers in sorted TGA output',0dh,0ah

errmsg1         db      'Error opening input file!$'
errmsg2         db      'Not enough extended memory to load file!!!$'

inputname       db 60 dup (?)
filelen         dd ?
outputname      db 60 dup (?)
labellen        dd ?

outptr          dd ?
addvalue        db 5 dup (0)

pallet          dd 999 dup (?)
psize           dw 0

xsize           dw 0
xcount          dw 0
ysize           dw 0

temp1           dw 0
temp2           dw 0

inverted        db 0

chars      db "0123456789abcdef"
byte2      db "0",0
vc         dd 0
xq         dw 0

;
; CODE
;

include strltu.rt
include strhtn.rt

;-----------------------------------------------------------------------------
exiterr2:
        mov edx,offset errmsg2
        jmp short exiterr
;-----------------------------------------------------------------------------
exiterr1:
        mov edx,offset errmsg1
        jmp short exiterr
;-----------------------------------------------------------------------------
exiterr0:
        mov edx,offset errmsg0
exiterr:
        call _putdosmsg
        jmp _exit

;

_main:
        xor al,al                       ; chek for filename on commandline
        mov edx,offset inputname
        call _cchekstr
        jc exiterr0

        call _openfile                  ; attempt to open file
        jc exiterr1

        mov eax,4000h                   ; setup file buffer
        call _getlomem
        mov _filebufloc,eax

        call _filesize
        mov filelen,eax

        call _gethimem                  ; chek for, and get enough himem
        jc exiterr2
        mov outptr,eax

        mov edx,outptr                  ; load file into himem
        mov ecx,filelen                 ; restore actual filesize for load
        call _readfile
        call _closefile                 ; file is in memory! kowabunga!

;

; test if add switch used

        mov al,'a'                      ; chek for add switch
        call _cchekswitch
        jc short mf0

        mov edx,offset addvalue         ; misc data ptr
        call _ccheksstr
        call _strltu                    ; convert string to number
        call _strhtn
        call vct
        mov addvalue,al
        jmp mf1
mf0:
        mov addvalue,1
mf1:

; set up output file name

        mov ecx,8
        mov edi,0
        mov edx,0
mn:
        mov al,inputname[di]
        cmp al,"."
        je nt
        inc edx
        mov outputname[di],al
        inc di
        loop mn
nt:
        mov outputname[di+0],"."
        mov outputname[di+1],"i"
        mov outputname[di+2],"n"
        mov outputname[di+3],"c"
        mov outputname[di+4],0

        mov labellen,edx

        mov edx,offset outputname
        call _createfile

; find info on this tga file

        mov esi,outptr
        add esi,12
        lodsw
        mov xsize,ax                      ; x size
        lodsw
        mov ysize,ax                      ; y size
        lodsb
        lodsb
        mov inverted,al                   ; is tga inverted, 20h if so
        mov outptr,esi                    ; esi = begining of file

        movzx eax,xsize
        movzx ecx,ysize
        mul ecx
        mov ebx,3             ; 3 bytes per pel
        mul ebx
        mov filelen,eax

; find number of colours in tga file

        mov ecx,filelen
        mov esi,outptr
        mov psize,0

        cld

n_loop:
        mov eax,0            ; output matrix
        lodsb
        mov dl,al
        lodsb
        mov bl,al
        lodsb
        shl eax,8
        mov al,bl
        shl eax,8
        mov al,dl
        shl eax,8

        cmp eax,0
        je old1

        mov di,0
k_loop:
        mov bp, di
        shr bp, 2
        cmp bp, psize
        jge foundnew
        cmp eax,pallet[di]
        je old1
        add di,4
        jmp k_loop

foundnew:
        mov pallet[edi],eax
        inc psize
        cmp psize,999
        je outfast
old1:
        sub ecx,3
        cmp ecx,0
        ja n_loop
outfast:

; write number of colours detected:x
; then write pallet lable

        call write_number

        mov ax,psize
        call write_ax_asdec
        call write_ret
        call write_ret

        mov ecx,labellen                  ; write output name as label
        mov edx,offset outputname
        call _writefile
        call writepallet

; sort colours in pallet

           movzx ecx,psize

           cmp ecx,2
           jle quickex

nextccx:
           mov bx,0               ; sort flag
           dec cx
           jcxz quickex
           mov si,psize
           dec si
           shl si,2
nextddx:
           sub si,4

           mov eax,pallet[si+4]
           cmp eax,pallet[si]
           jae donotng
           xchg eax,pallet[si]
           xchg eax,pallet[si+4]
           inc bx                 ; flag that one sorted
donotng:
           cmp si,0
           jne nextddx

           cmp bx,0               ; re-sort until no more sorts
           jne nextccx
quickex:

; write pallet to file

          mov temp1,0
          mov al,addvalue
          mov ah,0
          mov temp2,ax

wri_loop:
          call write_db

          mov al,"0"
          call writeit

          mov di,temp1
          mov al,byte ptr pallet[di+3]
          shr al,2
          call write_al_ashex
          mov al,"h"
          call writeit
          call write_comma
          mov al,"0"
          call writeit

          mov di,temp1
          mov al,byte ptr pallet[di+2]
          shr al,2
          call write_al_ashex
          mov al,"h"
          call writeit
          call write_comma
          mov al,"0"
          call writeit

          mov di,temp1
          mov al,byte ptr pallet[di+1]
          shr al,2
          call write_al_ashex
          mov al,"h"
          call writeit

          add temp1,4

          mov al," "
          call writeit
          mov al,";"
          call writeit
          mov al," "
          call writeit
          mov ax,temp2
          inc temp2
          call write_ax_asdec
          call write_ret

          mov ax,psize
          mov bx,4
          mul bx
          cmp temp1,ax
          jl wri_loop

        call write_ret

        mov ecx,labellen                 ; write output name as label
        mov edx,offset outputname
        call _writefile

        call write_dw

        mov ax,xsize
        call write_ax_asdec
        call write_comma
        mov ax,ysize
        call write_ax_asdec
        call write_comment

        call write_db

        mov esi,outptr

        mov ax,xsize
        mov xcount,ax

        cmp inverted,0
        je  doup


na_loop2:
        mov eax,0            ; output matrix
        lodsb
        mov dl,al
        lodsb
        mov bl,al
        lodsb
        shl eax,8
        mov al,bl
        shl eax,8
        mov al,dl
        shl eax,8

        cmp eax,0
        je old3

        mov di,0

k_loop2:
        mov bp, di
        shr bp, 2
        cmp bp, psize
        jge foundnew2
        cmp eax,pallet[di]
        je old2
        add di,4
        jmp k_loop2

old2:
        mov ax,di
        shr ax,2
        add al,addvalue
old3:
        push esi
        call write_ax_asdec
        cmp xcount,1
        je skc
        call write_comma
skc:
        pop esi

foundnew2:
        dec xcount
        jne na_loop2

        push esi
        call write_ret
        cmp ysize,1
        je  ndb
        call write_db
ndb:
        pop esi
        mov ax,xsize
        mov xcount,ax

        dec ysize
        jne na_loop2

        call _closefile

        jmp _exit

; do upside down tga file (byte 18 <> $20)

doup:
        movzx eax,xsize
        movzx ebx,ysize
        mov ecx,3
        dec ebx
        mul ebx
        mul ecx
        mov esi,eax
        add esi,outptr

na_loop3:
        mov eax,0            ; output matrix
        lodsb
        mov dl,al
        lodsb
        mov bl,al
        lodsb
        shl eax,8
        mov al,bl
        shl eax,8
        mov al,dl
        shl eax,8

        cmp eax,0
        je old5

        mov di,0

k_loop3:
        mov bp, di
        shr bp, 2
        cmp bp, psize
        jge foundnew3
        cmp eax,pallet[di]
        je old4
        add di,4
        jmp k_loop3

old4:
        mov ax,di
        shr ax,2
        add al,addvalue
old5:
        push esi
        call write_ax_asdec
        cmp xcount,1
        je sk1
        call write_comma
sk1:
        pop esi

foundnew3:
        dec xcount
        jne na_loop3

        push esi
        call write_ret
        cmp ysize,1
        je  nd1
        call write_db
nd1:
        pop esi
        mov ax,xsize
        mov xcount,ax

        dec ysize
        jne doup

        call _closefile

        jmp _exit

write_dw:
           mov ecx,4
           mov edx,offset textdw
           call _writefile
           ret

textdw     db " dw "

write_number:
           mov ecx,textgf-textde
           mov edx,offset textde
           call _writefile
           ret

textde     db "; number of colours detected: "
textgf:

write_comment:
           mov ecx,textgo-textdi
           mov edx,offset textdi
           call _writefile
           ret

textdi     db " ; x,y size of icon",13,10
textgo:

write_db:
           mov ecx,4
           mov edx,offset textdb
           call _writefile
           ret

textdb     db " db "

writepallet:
           mov ecx,7
           mov edx,offset textdp
           call _writefile
           ret

textdp     db "palette"

write_ret:
           mov ecx,2
           mov edx,offset textret
           call _writefile
           ret

textret    db 13,10

write_al_ashex:
           push ax
           shr al,4
           call dropchar
           pop ax
           call dropchar
           ret
dropchar:
           and ax,0fh
           mov si,ax
           mov bl,chars[si]
           mov byte2,bl
           mov edx, offset byte2
           mov ecx,1
           call _writefile
           ret

write_ax_asdec:
           call _cv

           mov xq,0
           mov vc,eax

           shr eax,16
           call dropchar2
           shr eax,12
           call dropchar2
           shr eax,8
           call dropchar2
           shr eax,4
           call dropchar2
           mov xq,1
           call dropchar2
           ret

dropchar2:
           and ax,0fh
           cmp ax,0
           jne jo0
           cmp xq,0
           je nxq
jo0:
           mov xq,1
           and ax,0fh
           mov si,ax
           mov bl,chars[si]
           mov byte2,bl
           mov edx, offset byte2
           mov ecx,1
           call _writefile
nxq:
           mov eax,vc
           ret

_cv:
        xor ecx,ecx
        xor dx,dx
        mov bx,10000
        div bx
        or cl,al
        shl ecx,4
        mov ax,dx
        xor dx,dx
        mov bx,1000
        div bx
        or cl,al
        shl ecx,4
        mov ax,dx
        xor dx,dx
        mov bx,100
        div bx
        or cl,al
        shl ecx,4
        mov ax,dx
        xor dx,dx
        mov bx,10
        div bx
        or cl,al
        shl ecx,4
        or cl,dl
        mov eax,ecx
        ret

vct:
        push ax
        shr ax,8
        mov bx,100
        and ax,0fh
        mul bx
        mov cx,ax
        pop ax

        push ax
        shr ax,4
        mov bx,10
        and ax,0fh
        mul bx
        add cx,ax
        pop ax

        and ax,0fh
        add ax,cx

        ret

write_comma:
           mov al,","
           call writeit
           ret
write_0:
           mov al,"0"
           call writeit
           ret
writeit:
           mov byte2,al
           mov edx,offset byte2
           mov ecx,1
           call _writefile
           ret

_putdosmsg:
        push ax
        push edx
        add edx,_code32a
        mov al,dl
        and ax,0fh
        shr edx,4
        mov v86r_ds,dx
        mov v86r_dx,ax
        mov v86r_ah,9
        mov al,21h
        int 33h
        pop edx
        pop ax
        ret

code32  ends
        end
