#include "windows.h"
#include "resource.h"
#include "blowfish.h"

#define MAX_NAME_LEN 0x64

char szName[MAX_NAME_LEN]={0};
char szCode[MAX_NAME_LEN]={0};

unsigned char szKey[]={
	0xBC, 0xDA, 0x16, 0x7E, 0x85, 0x33, 0x39, 0x54, 0xB0, 0xE1,
	0xC8, 0x5A, 0xAA, 0x07, 0xF0, 0x53, 0x18, 0xF7, 0xCF, 0x31,
	0x00
};
unsigned char szIVEC[]={
	0x82, 0x3A, 0xAA, 0x38, 0x74, 0x76, 0x10, 0x2E,
	0x00
};

HANDLE hInst;

void EntryPoint();
void CenterDialog(HWND hwndDlg);
BOOL CALLBACK MainHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK AboutHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);

static char BASE64_CODE[] = "0123456789@ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz";

void ToBase64(char szInput[3], char szOutput[4], int nLen)
{
	unsigned char szBuf[3];
	memset(szBuf, '\0', 3);
	memcpy(szBuf, szInput, nLen);	
	szOutput[0] = BASE64_CODE[szBuf[0] >> 2];
	szOutput[1] = BASE64_CODE[(szBuf[0] & 0x03) << 4 | szBuf[1] >> 4];
	if (nLen >= 2)
		szOutput[2] = BASE64_CODE[(szBuf[1] & 0x0f) << 2 | szBuf[2] >> 6];
	else
		szOutput[2] = '=';
	if (nLen == 3)
		szOutput[3] = BASE64_CODE[szBuf[2] & 0x3f];
	else
		szOutput[3] = '=';
}

void Base64Encode(char * szInput, int nLen, char * szOutput, int * pLen)
{
	int i;
	char szBuf[5];		
	szBuf[4] = '\0';
	szOutput[0] = '\0';
	*pLen = 0;
	for (i = 0; i < nLen; i += 3)
	{
		ToBase64(szInput + i, szBuf, min(nLen - i, 3));
		lstrcat(szOutput, szBuf);
		*pLen += 4;
	}
}

void Calculate(DWORD Length, DWORD MachineID)
{
	int k;
	unsigned char sum;
	BF_KEY BFK;

	BF_set_key(&BFK, 0x14, szKey);	
	for (k = 0, sum = 0xAA; k < Length; k++) sum ^= szName[k];
	__asm
	{	
		mov dword ptr [szIVEC], 0x38AA3A82
		mov dword ptr [szIVEC+4], 0x2E107674
		mov eax, MachineID
		mov dword ptr [szName], eax
		xor eax, eax
		mov dword ptr [szName+0x1C], eax
	}
	BF_cbc_encrypt((unsigned char*)szName, (unsigned char*)szName, 0x20, &BFK, szIVEC, BF_ENCRYPT);
	szName[0x20]=sum;
	lstrcpy(szName+0x21, "DUE");
	Base64Encode(szName, 0x24, szCode, &k);
}

void EntryPoint()
{
	hInst = GetModuleHandle(NULL);
	ExitProcess(DialogBoxParam((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_MAINDLG), 0, (DLGPROC)MainHandler, IDD_MAINDLG));
}

void CenterDialog(HWND hwndDlg)
{
	RECT Dlg, Desktop;
	DWORD Height, Width, DeskX, DeskY;
	GetWindowRect(hwndDlg, &Dlg);
	GetWindowRect(GetDesktopWindow(), &Desktop);
	Width = Dlg.right - Dlg.left;
	Height = Dlg.bottom - Dlg.top;
	DeskX = (Desktop.right - Width) >> 1;
	DeskY = (Desktop.bottom - Height) >> 1;	
	MoveWindow(hwndDlg, DeskX, DeskY, Width, Height, NULL);
}

BOOL CALLBACK MainHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	DWORD Length, MachineID;
	switch(uMsg)
	{
		case WM_CTLCOLOREDIT:
			if ((DWORD)lParam == (DWORD)GetDlgItem(hwndDlg, IDC_SERIAL))
			{
				SetBkColor((HDC)wParam, 0xC0C0C0);
				SetTextColor((HDC)wParam, NULL);
				CreateSolidBrush(0xC0C0C0);
			}
			break;
		case WM_INITDIALOG:
			CenterDialog(hwndDlg);
			SendDlgItemMessageA(hwndDlg, IDC_NAME, EM_SETLIMITTEXT, MAX_NAME_LEN-1, NULL);			
			SendDlgItemMessageA(hwndDlg, IDC_MACHINE, EM_SETLIMITTEXT, 10, NULL);

			GetVolumeInformation("C:\\", NULL, NULL, &MachineID, NULL, NULL, NULL, NULL);
			wsprintf(szName, "%010lu", MachineID);
			SendDlgItemMessage(hwndDlg, IDC_MACHINE, WM_SETTEXT, NULL, (LPARAM)szName);
			SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)"Please enter your name and machine ID in the editboxes above...");
			SetFocus(GetDlgItem(hwndDlg, IDC_NAME));
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
				case IDC_EXIT:
					EndDialog(hwndDlg, NULL);
					break;
				case IDC_MACHINE:
				case IDC_NAME:
					if (HIWORD(wParam) == EN_UPDATE)
					{
						SendDlgItemMessage(hwndDlg, IDC_MACHINE, WM_GETTEXT, MAX_NAME_LEN, (LPARAM)szName);
						MachineID = atoi(szName);
						RtlZeroMemory(szName, MAX_NAME_LEN);
						Length = SendDlgItemMessage(hwndDlg, IDC_NAME, WM_GETTEXT, MAX_NAME_LEN, (LPARAM)szName);
						if ((Length) && (MachineID))
						{
							Calculate(Length, MachineID);
							SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)szCode);
						}
						else
						{
							SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)"Please enter your name and machine ID in the editboxes above...");
							break;
						}
					}
					break;
				case IDC_ABOUT:
					DialogBoxParam((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_ABOUTDLG), hwndDlg, (DLGPROC)AboutHandler, IDD_ABOUTDLG);
				default:
					DefWindowProc(hwndDlg, uMsg, wParam, lParam);
			}
			break;
		default:
			DefWindowProc(hwndDlg, uMsg, wParam, lParam);
	};
	return(FALSE);
}

BOOL CALLBACK AboutHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_INITDIALOG:
			CenterDialog(hwndDlg);
			break;
		case WM_COMMAND:
			if (wParam == IDC_CLOSE) EndDialog(hwndDlg, NULL);
			break;
		default:
			DefWindowProc(hwndDlg, uMsg, wParam, lParam);
	};
	return(FALSE);
};