#include "windows.h"
#include "resource.h"

#define MAX_NAME_LEN 96

char szName[MAX_NAME_LEN*2]={0};
char szCode[MAX_NAME_LEN*2]={0};
char szTemp[MAX_NAME_LEN*2]={0};
char DESpw [15];

HANDLE hInst;

void		   EntryPoint();
void		   CenterDialog(HWND hwndDlg);
extern "C"	   int lzhcompress(unsigned char *a, int b, unsigned char *c);
extern "C"     int des_encrypt(unsigned char *a, unsigned char *b, int c, unsigned char *d);
BOOL CALLBACK  MainHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK  AboutHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);

/* BEGIN OF PROTECTECTION ALGORITHM */

void WriteID(unsigned char *s)
{
	*((unsigned long*)s)      =4;						/* stream pointer */
	*((unsigned long*)(s + 4))=0x30465054;				/* stream type    */
}

void WriteListBegin(unsigned char *s)
{
	s[*((unsigned long*)s) + 4]=1;						/* list begin id  */
	*((unsigned long*)s)+=1;     					    /* stream pointer */
}

void WriteListEnd(unsigned char *s)
{
	s[*((unsigned long*)s) + 4]=0;						/* list end id    */
	*((unsigned long*)s)+=1;     					    /* stream pointer */
}

void WriteString(unsigned char *s, char *x)
{
	s[*((unsigned long*)s) + 4]=6;					    /* string id      */
	s[*((unsigned long*)s) + 5]=strlen(x);			    /* string len     */
	memcpy(s + *((unsigned long*)s) + 6, x, strlen(x)); /* string itself  */

	*((unsigned long*)(s + 0))+=strlen(x)+2;		    /* stream pointer */
}

void WriteString(unsigned char *s, char *x, int i)
{
	s[*((unsigned long*)s) + 4]=6;					    /* string id      */
	s[*((unsigned long*)s) + 5]=i;					    /* string len     */
	memcpy(s + *((unsigned long*)s) + 6, x, i);		    /* string itself  */

	*((unsigned long*)(s + 0))+=i+2;				    /* stream pointer */
}

void WriteInteger(unsigned char *s, int i)
{
	s[*((unsigned long*)s) + 4]=2;					    /* 8-bit int id   */
	s[*((unsigned long*)s) + 5]=(unsigned char)i;		/* int itself     */

	*((unsigned long*)s)+=2;     						/* stream pointer */
}

void WriteBool(unsigned char *s, bool b)
{
	if (b)
		s[*((unsigned long*)s) + 4]=9;					/* id for true    */
	else
		s[*((unsigned long*)s) + 4]=8;					/* id for false   */

	*((unsigned long*)s)+=1;							/* stream pointer */
}

int  GetStreamSize(unsigned char *s)
{
	return *((unsigned long*)s);
}

void Calculate(unsigned long iLen)
{
	unsigned long    k, iWriten;
	HANDLE		     hFile;
	unsigned char    bToEncode[0x704], bEncoded[0x710];
	bool			 bOK;

	memset(bToEncode, 0, 0x704);
	memset(bEncoded , 0, 0x710);

	WriteID(bToEncode);
	WriteListBegin(bToEncode);

	for (k=0; k<5; k++)
	{
		wsprintf(szCode, "Field%d", k);

		WriteString(bToEncode, szCode);
		WriteString(bToEncode, "String");
		WriteInteger(bToEncode, 0x7F);

		
		WriteString(bToEncode, szCode);
		WriteString(bToEncode, "String");
		WriteInteger(bToEncode, 0x7F);

		WriteBool(bToEncode, FALSE);
		WriteBool(bToEncode, FALSE);
	}
	
	WriteListEnd(bToEncode);

	//

	WriteListBegin(bToEncode);

	do
	{
		bOK=TRUE;

		wsprintf(DESpw, "%08X", rand()*rand()*rand());		
	
		des_encrypt((unsigned char*)DESpw, (unsigned char*)szName, iLen + (8 - (iLen%8)), (unsigned char*)szTemp);
		for (k=0; k<(iLen + (8 - (iLen%8))); k++)
			if (szTemp[k]==0)
				bOK=FALSE;

		iLen=wsprintf(szCode, "%05X-%03X-%08X", (rand()*rand())%0xFFFFF, (rand()*rand())%0xFFF, (rand()*rand()*rand())%0xFFFFFFF);
		des_encrypt((unsigned char*)DESpw, (unsigned char*)szCode, iLen + (8 - (iLen%8)), (unsigned char*)szTemp);
		for (k=0; k<(iLen + (8 - (iLen%8))); k++)
			if (szTemp[k]==0)
				bOK=FALSE;

		des_encrypt((unsigned char*)"TListBox", (unsigned char*)DESpw, 8, (unsigned char*)szTemp);
		for (k=0; k<8; k++)
			if (szTemp[k]==0)
				bOK=FALSE;

		memset(szCode, 0, 8);
		strcpy(szCode, "5");
		des_encrypt((unsigned char*)DESpw, (unsigned char*)szCode, 8, (unsigned char*)szTemp);
		for (k=0; k<8; k++)
			if (szTemp[k]==0)
				bOK=FALSE;
	}
	while (bOK!=TRUE);

	//

	des_encrypt((unsigned char*)DESpw, (unsigned char*)szName, iLen + (8 - (iLen%8)), (unsigned char*)szTemp);
	WriteString(bToEncode, szTemp, iLen + (8 - (iLen%8)));

	iLen=wsprintf(szName, "%05X-%03X-%08X", (rand()*rand())%0xFFFFF, (rand()*rand())%0xFFF, (rand()*rand()*rand())%0xFFFFFFF);
	des_encrypt((unsigned char*)DESpw, (unsigned char*)szName, iLen + (8 - (iLen%8)), (unsigned char*)szTemp);
	WriteString(bToEncode, szTemp, iLen + (8 - (iLen%8)));

	des_encrypt((unsigned char*)"TListBox", (unsigned char*)DESpw, 8, (unsigned char*)szTemp);
	WriteString(bToEncode, szTemp, 8);

	WriteString(bToEncode, "(C) Duelist/CORE in 2000");

	memset(szCode, 0, 8);
	strcpy(szCode, "5");
	des_encrypt((unsigned char*)DESpw, (unsigned char*)szCode, 8, (unsigned char*)szTemp);
	WriteString(bToEncode, szTemp, 8);

	WriteListEnd(bToEncode);

	//

	k=lzhcompress(bToEncode+4, GetStreamSize(bToEncode), (unsigned char*)bEncoded);

	hFile=CreateFile("AATools.dat", GENERIC_WRITE, NULL, NULL, CREATE_ALWAYS, NULL, NULL);
	WriteFile(hFile, bEncoded, k, &iWriten, NULL);
	CloseHandle(hFile);

	strcpy(szCode, "Your keyfile, AATools.dat, has been generated.");
}

/* END OF PROTECTECTION ALGORITHM */

void main()
{
	hInst = GetModuleHandle(NULL);
	ExitProcess(DialogBoxParam((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_MAINDLG), 0, (DLGPROC)MainHandler, IDD_MAINDLG));
}

void CenterDialog(HWND hwndDlg)
{
	RECT Dlg, Desktop;
	DWORD Height, Width, DeskX, DeskY;
	GetWindowRect(hwndDlg, &Dlg);
	GetWindowRect(GetDesktopWindow(), &Desktop);
	Width = Dlg.right - Dlg.left;
	Height = Dlg.bottom - Dlg.top;
	DeskX = (Desktop.right - Width) >> 1;
	DeskY = (Desktop.bottom - Height) >> 1;	
	MoveWindow(hwndDlg, DeskX, DeskY, Width, Height, NULL);
}

BOOL CALLBACK MainHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	int iLen;
	switch(uMsg)
	{
		case WM_CTLCOLOREDIT:
			if ((DWORD)lParam == (DWORD)GetDlgItem(hwndDlg, IDC_SERIAL))
			{
				SetBkColor((HDC)wParam, 0xC0C0C0);
				SetTextColor((HDC)wParam, NULL);
				CreateSolidBrush(0xC0C0C0);
			}
			break;
		case WM_INITDIALOG:
			srand(GetTickCount());
			CenterDialog(hwndDlg);
			SendDlgItemMessageA(hwndDlg, IDC_NAME, EM_SETLIMITTEXT, MAX_NAME_LEN, NULL);
			SendDlgItemMessage(hwndDlg, IDC_SERIAL , WM_SETTEXT, NULL, (LPARAM)"00000-000-00000000");
			SendDlgItemMessage(hwndDlg, IDC_SERIAL2, WM_SETTEXT, NULL, (LPARAM)"Please enter your name in the editbox above...");			
			SetFocus(GetDlgItem(hwndDlg, IDC_NAME));
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
				case IDC_EXIT:
					memset(szName, 0, MAX_NAME_LEN);
					iLen = SendDlgItemMessage(hwndDlg, IDC_NAME, WM_GETTEXT, MAX_NAME_LEN+1, (LPARAM)szName);
					if (iLen)
					{
						Calculate(iLen);
						SendDlgItemMessage(hwndDlg, IDC_SERIAL , WM_SETTEXT, NULL, (LPARAM)szName);
						SendDlgItemMessage(hwndDlg, IDC_SERIAL2, WM_SETTEXT, NULL, (LPARAM)szCode);
					}
					else
					{
						SendDlgItemMessage(hwndDlg, IDC_SERIAL , WM_SETTEXT, NULL, (LPARAM)"00000-000-00000000");
						SendDlgItemMessage(hwndDlg, IDC_SERIAL2, WM_SETTEXT, NULL, (LPARAM)"Please enter your name in the editbox above...");
						break;
					}
					break;
				case IDC_ABOUT:
					DialogBoxParam((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_ABOUTDLG), hwndDlg, (DLGPROC)AboutHandler, IDD_ABOUTDLG);
				default:
					DefWindowProc(hwndDlg, uMsg, wParam, lParam);
			}
			break;
		default:
			DefWindowProc(hwndDlg, uMsg, wParam, lParam);
	};
	return(FALSE);
}

BOOL CALLBACK AboutHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_INITDIALOG:
			CenterDialog(hwndDlg);
			break;
		case WM_COMMAND:
			if (wParam == IDC_CLOSE) EndDialog(hwndDlg, NULL);
			break;
		default:
			DefWindowProc(hwndDlg, uMsg, wParam, lParam);
	};
	return(FALSE);
};