#include "blowfish.h"
#include "windows.h"
#include "resource.h"

#define MAX_NAME_LEN 0x64

char szTemp[20];
char szName[MAX_NAME_LEN*2];
char szComp[MAX_NAME_LEN  ];
char szCode[MAX_NAME_LEN  ];

HANDLE hInst;

void EntryPoint();
void CenterDialog(HWND hwndDlg);
BOOL CALLBACK MainHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK AboutHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);

/* BEGIN OF PROTECTECTION ALGORITHM */

void Calculate(DWORD Length, DWORD numLics)
{
	int    k;
	BF_KEY blowfish;

	strcpy(szTemp, "bcdefghijklmnopqr");
	szTemp[0]=szName[0];
	szTemp[1]=szName[strlen(szName)-1];

	if (strlen(szComp)!=0)
	{
		szTemp[2]=szComp[0];
		szTemp[3]=szComp[strlen(szComp)-1];
		szTemp[4]=(char)((numLics%0x1A)+0x61);
		strcat(szName, szComp);
	}
	else
		szTemp[2]=(char)((numLics%0x1A)+0x61);


	wsprintf(szComp, "%d", numLics);
	strcat(szName, szComp);

	BF_set_key(&blowfish, strlen(szName), (unsigned char*)szName);	
	BF_ecb_encrypt((unsigned char*)szTemp, (unsigned char*)szTemp, &blowfish, BF_ENCRYPT);
	BF_ecb_encrypt((unsigned char*)(szTemp+8), (unsigned char*)(szTemp+8), &blowfish, BF_ENCRYPT);

	szCode[0]=0;
	for (k=0; k<0x10; k++)
	{
		if (szTemp[k]==0)
			break;
		if ((k%2==0) && (k!=0))
			strcat(szCode, " ");
		wsprintf(szCode+strlen(szCode), "%02X", szTemp[k]&0xFF);
	}
}

/* END OF PROTECTECTION ALGORITHM */

void main()
{
	hInst = GetModuleHandle(NULL);
	ExitProcess(DialogBoxParam((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_MAINDLG), 0, (DLGPROC)MainHandler, IDD_MAINDLG));
}

void CenterDialog(HWND hwndDlg)
{
	RECT Dlg, Desktop;
	DWORD Height, Width, DeskX, DeskY;
	GetWindowRect(hwndDlg, &Dlg);
	GetWindowRect(GetDesktopWindow(), &Desktop);
	Width = Dlg.right - Dlg.left;
	Height = Dlg.bottom - Dlg.top;
	DeskX = (Desktop.right - Width) >> 1;
	DeskY = (Desktop.bottom - Height) >> 1;	
	MoveWindow(hwndDlg, DeskX, DeskY, Width, Height, NULL);
}

BOOL CALLBACK MainHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	int Length, Lics;
	
	switch(uMsg)
	{
		case WM_CTLCOLOREDIT:
			if ((DWORD)lParam == (DWORD)GetDlgItem(hwndDlg, IDC_SERIAL))
			{
				SetBkColor((HDC)wParam, 0xC0C0C0);
				SetTextColor((HDC)wParam, NULL);
				CreateSolidBrush(0xC0C0C0);
			}
			break;
		case WM_INITDIALOG:
			CenterDialog(hwndDlg);
			SendDlgItemMessageA(hwndDlg, IDC_NAME, EM_SETLIMITTEXT, MAX_NAME_LEN, NULL);
			SendDlgItemMessage(hwndDlg, IDC_NLIC, WM_SETTEXT, NULL, (LPARAM)"20");			
			SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)"Please enter your name and number of licenses in the editboxes above...");
			SetFocus(GetDlgItem(hwndDlg, IDC_NAME));
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
				case IDC_EXIT:
					EndDialog(hwndDlg, NULL);
					break;
				case IDC_COMP:
				case IDC_NAME:
				case IDC_NLIC:
					if (HIWORD(wParam) == EN_UPDATE)
					{					
						SendDlgItemMessage(hwndDlg, IDC_COMP, WM_GETTEXT, MAX_NAME_LEN+1, (LPARAM)szComp);
						Length = SendDlgItemMessage(hwndDlg, IDC_NAME, WM_GETTEXT, MAX_NAME_LEN+1, (LPARAM)szName);						
						Lics = GetDlgItemInt(hwndDlg, IDC_NLIC, NULL, NULL);

						if (Lics > 999)
						{
							SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)"999 lics are more than enough. Choose a number below that!");
							break;
						}
						if (Length && Lics)
						{
							Calculate(Length, Lics);
							SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)szCode);
						}
						else
						{
							SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)"Please enter your name and number of licenses in the editboxes above...");
							break;
						}
					}
					break;
				case IDC_ABOUT:
					DialogBoxParam((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_ABOUTDLG), hwndDlg, (DLGPROC)AboutHandler, IDD_ABOUTDLG);
				default:
					DefWindowProc(hwndDlg, uMsg, wParam, lParam);
			}
			break;
		default:
			DefWindowProc(hwndDlg, uMsg, wParam, lParam);
	};
	return(FALSE);
}

BOOL CALLBACK AboutHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_INITDIALOG:
			CenterDialog(hwndDlg);
			break;
		case WM_COMMAND:
			if (wParam == IDC_CLOSE) EndDialog(hwndDlg, NULL);
			break;
		default:
			DefWindowProc(hwndDlg, uMsg, wParam, lParam);
	};
	return(FALSE);
};