#include "windows.h"
#include "resource.h"
#include "bn.h"

#define MAX_NAME_LEN 0x64

char endptr[]="-";
char szName[MAX_NAME_LEN]={0};
char szTemp[MAX_NAME_LEN]={0};
char szCode[MAX_NAME_LEN]={0};

HANDLE hInst;

void EntryPoint();
void CenterDialog(HWND hwnddl1g);
BOOL CALLBACK MainHandler(HWND hwnddl1g, UINT uMsg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK AboutHandler(HWND hwnddl1g, UINT uMsg, WPARAM wParam, LPARAM lParam);

unsigned long bswap(unsigned long x)
{
	__asm mov eax, [x]
	__asm bswap eax
	__asm mov [x], eax

	return x;
}

int testsize(unsigned long x)
{
	if (x==0)
		return 0;
	if (x<=0xFF)
		return 1;
	if (x<=0xFFFF)
		return 2;
	if (x<=0xFFFFFF)
		return 3;
	if (x<=0xFFFFFFFF)
		return 4;

	return 5;
}

unsigned long to_base18(char *s)
{
	int			  k;
	char		  dl1;
	unsigned long base18;

	if (strlen(s)==0)	 return 0;

	for (k=1, base18=0; k<(int)strlen(s)+1; k++)
	{
		if (s[k-1]=='-') return base18;

		base18<<=3;
		base18 *=3;

		dl1=s[k-1];
		dl1+=(char)0xBF;
		dl1-=(char)0x1A;

		__asm jnb stloc
		
		dl1    =s[k-1];
		base18+=dl1;
		base18-=0x41;
		base18+=0x0A;

	stloc:		

		dl1=s[k-1];
		dl1+=(char)0xD0;
		dl1-=(char)0x0A;

		__asm jnb ndloc

		dl1    =s[k-1];
		base18+=dl1;
		base18-=0x30;

	ndloc:;
	}
	return base18;
}
	
void Calculate(DWORD Length)
{
		char *rsa_e[]=
		{
			"26075",
			"864888740612193742689017",
			"40709",
			"228420036942438144476557",
			"39011",
			"212297430977734717482191",
			"37889",
			"352831828111866565203947",
			"41467",
			"138831595151585446280669",
			"35917",
			"224407122384526341758447",
			"41155",
			"243102714002050476117619",
			"25933",
			"432967529402268806070791",
			"31175",
			"469540330261658061297107",
			"36137",
			"230635029922449185383187",
			"39719",
			"131039394467322558967207",
			"24497",
			"298244803676220969179971",
			"31397",
			"798722042491766212105063",
			"36365",
			"236928512044612325329411",
			"41603",
			"137354872679695417182881",
			"23335",
			"182051350869344582069981",
		},
		*rsa_d[]=
		{
			"043829037719787664243523",
			"182243127267562025096639",
			"303811082973844310813963",
			"414461296905621623953159",
			"110045705359834617176611",
			"616875559145474609947081",
			"132369297905005849770329",
			"217223431514764989342251",
			"080585107491965199486587",
			"171899180821342072074271",
			"152500041193810521864101",
			"268152590991176086606321",
			"127680886933836810508299",
			"288286265547809186237257",
			"022016746152146368734443",
			"510808231425155460531409",
			"089171728738400617530937",
			"724883675866234437355811",
			"370753129232222568046903",
			"916881129109887882047053",
			"460613194367426996826379",
			"999610394866866487127611",
			"084332475236932251843131",
			"774314381964892676788333",
			"003357002656370949951089",
			"227226733734289164598721",
			"026909409592668362874867",
			"128390453313422768521423",
			"312349155415934793728815",
			"425984051452666136987411",
			"037222211049926510824523",
			"404019424950783392294809",
		},									x;
		unsigned long     k,		c,		mk,			locebp10,		locebp14,		locesi,
						  len1,     len2,   len3,		locebp18,		loctmp,			rsa_o,
						  rsa_i,	i,		st_half,	nd_half,	    var_48,			var_4C,
						  var_34,	var_2C,	var_6C,		var_1F4,		var_1F8;
		
		//
		
		for (k=0, c=0; k < Length; k++)
			if (szName[k] == '-')
				c++;

		if (c != 4)
		{
			lstrcpy(szCode, "The product code you've entered seems invalid...");
			return;
		}

		//

		BIGNUM *N=BN_new();
		BIGNUM *E=BN_new();
		BIGNUM *R=BN_new();
		BIGNUM *A=BN_new();
		BN_CTX *CTX=BN_CTX_new();

		szTemp[0]=szName[0];
		szTemp[1]=0;
		rsa_i  = to_base18(szTemp);

		lstrcpyn(szTemp, szName+2, int((strchr(szName, 0x2D)-(char*)szName)-1));
		loctmp = to_base18(szTemp);
		loctmp = loctmp >> 3;
		len3   = (loctmp & 7) + 1;
		loctmp = loctmp >> 3;
		len2   = (loctmp & 7) + 1;
		loctmp = loctmp >> 3;
		len1   = (loctmp & 7) + 1;

		//

		k=strchr(szName, 0x2D)-szName;
		memset(szCode, 0, 40);
		for (c = 0; k < (DWORD)lstrlen(szName); k++)
		{
			if (szName[k]!='-') 
			{
				szCode[c++]=szName[k];
				szCode[c]=0;
			}
		}

		lstrcpyn(szTemp, szCode, len1);
		lstrcat (szTemp, "-");
		lstrcpyn(szTemp + lstrlen(szTemp), szCode + len1 - 1, len2);
		lstrcat (szTemp, "-");
		lstrcpyn(szTemp + lstrlen(szTemp), szCode + len1 + len2 - 2, len3);
		lstrcat (szTemp, "-");
		lstrcpy (szTemp + lstrlen(szTemp), szCode + len1 + len2 + len3 - 3);

		locebp10 = to_base18(szTemp);

		k=strchr(szTemp+0, 0x2D)-szTemp+1;
		locebp14 = to_base18(szTemp+k);

		k=strchr(szTemp+k, 0x2D)-szTemp+1;
		locesi   = to_base18(szTemp+k);

		k=strchr(szTemp+k, 0x2D)-szTemp+1;
		locebp18 = to_base18(szTemp+k);

		// All the code ABOVE seems acceptable

		k=0;
		memset(szCode, 0, 30);

		i=testsize(locebp10);
		locebp10=bswap(locebp10);
		mk=(unsigned long)&locebp10;
		mk=mk+4-i;
		memcpy(szCode+k, (void*)mk, i);
		k+=i;

		i=testsize(locebp14);
		locebp14=bswap(locebp14);
		mk=(unsigned long)&locebp14;
		mk=mk+4-i;
		memcpy(szCode+k, (void*)mk, i);
		k+=i;

		i=testsize(locesi);
		locesi=bswap(locesi);
		mk=(unsigned long)&locesi;
		mk=mk+4-i;
		memcpy(szCode+k, (void*)mk, i);
		k+=i;

		i=testsize(locebp18);
		locebp18=bswap(locebp18);
		mk=(unsigned long)&locebp18;
		mk=mk+4-i;
		memcpy(szCode+k, (void*)mk, i);
		k+=i;

		BN_dec2bn(&N, rsa_d[rsa_i*2+1]);
		BN_dec2bn(&E, rsa_d[rsa_i*2]);

		BN_bin2bn((unsigned char*)szCode, k, A);

		BN_mod_exp(R, A, E, N, CTX);

		for (k=BN_num_bits(R); k>=3; k--)
			if ( (BN_is_bit_set(R, k)==TRUE) && (BN_is_bit_set(R, k-1)==TRUE) && (BN_is_bit_set(R, k-2)==TRUE) )
			{
				BN_mask_bits(R, k-2);
				break;
			}

		memset(szCode, 0, 16);
		i=BN_bn2bin(R, (unsigned char*)szCode);

		if (i<5)
		{
			lstrcpy(szCode, "Due to bug in DJPower can't generate unlock pass for this product code!");
			return;
		}

		k=4;
		memcpy(szTemp, szCode, 4);
		while ((szTemp[0]==0) && (k>0))
		{
			memcpy(szTemp, szTemp+1, k);
			k--;
		}
		for (mk=0, locebp10=0; mk<k; mk++)
		{
			locebp10<<=8;			
			locebp10 |=szTemp[mk] & 0xFF;
		}

		k=i-4;
		memcpy(szTemp, szCode+4, i-4);
		while ((szTemp[0]==0) && (k>0))
		{
			memcpy(szTemp, szTemp+1, k);
			k--;
		}
		for (mk=0, locebp14=0; mk<k; mk++)
		{
			locebp14<<=8;
			locebp14 |=szTemp[mk] & 0xFF;

		}

		st_half = nd_half = 0;

		k	    = (locebp10 >> 24) & 0xFF;
		var_1F4 = k;
		var_1F8 = locebp14 ^ ( ((k - rsa_i) << 24) + ((k + rsa_i) << 16) + ((k - (rsa_i >> 1)) << 8) + (k >> 1) );

		// Make up the basic variables

		var_48  = ( ( (var_1F4 - rsa_i) / 3 ) + ( (rsa_i + var_1F4) << 6 ) ) & 0xFFFF;
		var_34  = (var_48 & 0xFF) | ( ( (0x100 ^ 2300) ^ var_48 ) & 0xFF00);

		// The most complicated stuff, reversed bottom-top

//		mk	    = ( ( (var_1F8 & 0xFFFF) + 7 ) ^ 4 ) ^ rsa_i;
		mk	    = ( ( 7 ^ (var_1F8 & 0xFFFF) ) ^ 4 ) ^ rsa_i;
		nd_half = nd_half | mk;

		k		= ( ( ( (var_1F8 & 0xFFFF) ^ rsa_i ) ^ ( (nd_half & 0xFFFF) ^ 4 ) ) >> 2 ) * var_1F8;

		var_6C  = (((var_1F8 ^ 0xBC3F) ^ k) & 0xFFFF);

		var_2C  = ( ( (int)(k * var_34) / (int)(rsa_i + 3) ) ^ var_6C) & 0xFFFF;

		// Make up the st_half of our data

		st_half = st_half | ( (var_2C - rsa_i) ^ var_48);
		st_half = st_half | ( ( (var_1F8 & 0xFFF) + 2300) << 16 );

		// Make up the nd_half of our data

		var_4C  = ( (st_half & 0xFFFF) ^ var_48 ) + rsa_i;

		nd_half = nd_half | ( ( (var_34 + rsa_i) ^ var_4C ) << 16 );

		//

		*(unsigned long*)(szName  )=bswap(st_half);
		*(unsigned long*)(szName+4)=bswap(nd_half);

		// All the code BELOW seems acceptable

		rsa_o=rand()%0x10;

		BN_dec2bn(&N, rsa_e[rsa_o*2+1]);
		BN_dec2bn(&E, rsa_e[rsa_o*2]);

		BN_bin2bn((unsigned char*)szName, 8, A);

		k=BN_num_bits(A);
		BN_set_bit(A, k++);
		BN_set_bit(A, k++);
		BN_set_bit(A, k++);

		BN_mod_exp(R, A, E, N, CTX);

		memset(szCode, 0, 16);
		BN_bn2bin(R, (unsigned char*)szCode);
		
		x=szCode[0];
		szCode[0]=szCode[1];
		szCode[1]=x;

		x=szCode[2];
		szCode[2]=szCode[3];
		szCode[3]=x;

		x=szCode[4];
		szCode[4]=szCode[5];
		szCode[5]=x;

		x=szCode[6];
		szCode[6]=szCode[9];
		szCode[9]=x;

		x=szCode[7];
		szCode[7]=szCode[8];
		szCode[8]=x;

		ltoa(*((unsigned short*)szCode)	   , szName                , 0x18);
		lstrcat(szName, "-");
		ltoa(*((unsigned short*)(szCode+2)), szName+lstrlen(szName), 0x18);
		lstrcat(szName, "-");	
		ltoa(*((unsigned short*)(szCode+4)), szName+lstrlen(szName), 0x18);
		lstrcat(szName, "-");
		ltoa(*((unsigned long *)(szCode+6)), szName+lstrlen(szName), 0x18);

		CharUpperBuff(szName, lstrlen(szName));

		//

		szCode[0]=0;
		
		for (k = 0, c = 0, mk = 0; k < (DWORD)lstrlen(szName); k++, c++)
		{
			if (szName[k] == '-')
			{
				mk = mk | c;
				mk = mk << 3;
				c = -1;
			}
		}

		mk = mk | c;
		ltoa(rsa_o, szCode  , 0x10);
		ltoa(mk   , szCode+1, 0x18);

		//

		for (k=0, mk=0; k<(unsigned long)lstrlen(szName); k++) 
			if (szName[k]!='-')
				mk=mk + szName[k] / 3;

		ltoa(mk, szTemp, 0x18);

		szCode[lstrlen(szCode)+1] = 0;
		szCode[lstrlen(szCode)  ] = szTemp[0];
		
		//

		lstrcat(szCode, "-");
		lstrcat(szCode, szName);
		CharUpperBuff(szCode, lstrlen(szCode));

		BN_free(N);
		BN_free(E);
		BN_free(R);
		BN_free(A);
		BN_CTX_free(CTX);
}

void EntryPoint()
{
		hInst = GetModuleHandle(NULL);
		ExitProcess(DialogBoxParam((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_MAINDLG), 0, (DLGPROC)MainHandler, IDD_MAINDLG));
}

void CenterDialog(HWND hwnddl1g)
{
		RECT dl1g, Desktop;
		DWORD Height, Width, DeskX, DeskY;
		GetWindowRect(hwnddl1g, &dl1g);
		GetWindowRect(GetDesktopWindow(), &Desktop);
		Width = dl1g.right - dl1g.left;
		Height = dl1g.bottom - dl1g.top;
		DeskX = (Desktop.right - Width) >> 1;
		DeskY = (Desktop.bottom - Height) >> 1;	
		MoveWindow(hwnddl1g, DeskX, DeskY, Width, Height, NULL);
	}

	BOOL CALLBACK MainHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
	{
		int Length;
		switch(uMsg)
		{
			case WM_CTLCOLOREDIT:
				if ((DWORD)lParam == (DWORD)GetDlgItem(hwndDlg, IDC_SERIAL))
				{
					SetBkColor((HDC)wParam, 0xC0C0C0);
					SetTextColor((HDC)wParam, NULL);
					CreateSolidBrush(0xC0C0C0);
				}
				break;
			case WM_INITDIALOG:
				srand(GetTickCount());
				CenterDialog(hwndDlg);
				SendDlgItemMessageA(hwndDlg, IDC_NAME, EM_SETLIMITTEXT, MAX_NAME_LEN, NULL);
				SendDlgItemMessageA(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)"Please insert the provided product code in the editbox above...");			
				SetFocus(GetDlgItem(hwndDlg, IDC_NAME));
				break;
			case WM_COMMAND:
				switch(LOWORD(wParam))
				{
					case IDC_EXIT:
						Length = SendDlgItemMessage(hwndDlg, IDC_NAME, WM_GETTEXT, MAX_NAME_LEN, (LPARAM)szName);
						if (Length)
						{
							Calculate(Length);
							SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)szCode);
						}
						else
						{
							SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)"Please insert the provided product code in the editbox above...");
							break;
						}
						break;
					case IDC_ABOUT:
						DialogBoxParam((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_ABOUTDLG), hwndDlg, (DLGPROC)AboutHandler, IDD_ABOUTDLG);
					default:
						DefWindowProc(hwndDlg, uMsg, wParam, lParam);
				}
				break;
			default:
				DefWindowProc(hwndDlg, uMsg, wParam, lParam);
		};
		return(FALSE);
	}

	BOOL CALLBACK AboutHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
	{
		switch(uMsg)
		{
			case WM_INITDIALOG:
				CenterDialog(hwndDlg);
				break;
			case WM_COMMAND:
				if (wParam == IDC_CLOSE) EndDialog(hwndDlg, NULL);
				break;
			default:
				DefWindowProc(hwndDlg, uMsg, wParam, lParam);
		};
		return(FALSE);
	};