#include "windows.h"
#include "resource.h"
#include "blowfish.h"
#include "time.h"

#define MAX_NAME_LEN 0x64

char szName[MAX_NAME_LEN]={0};
char szCode[MAX_NAME_LEN]={0};

HANDLE hInst;

void EntryPoint();
void CenterDialog(HWND hwndDlg);
BOOL CALLBACK MainHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK AboutHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);

void main()
{
}

void Calculate(DWORD Length)
{
	DWORD k, k1;
	BF_KEY blowfish;
	
	ZeroMemory(szCode, MAX_NAME_LEN);
	for (k=k1=0; k < Length; k++)
	{
		if (szName[k]!=0x20)
		{
			szCode[k1]=szName[k];
			if ((szCode[k1] >= 0x61) && (szCode[k1] <= 0x7A)) szCode[k1]-=0x20; 
			k1++;
		}
	}
	BF_set_key(&blowfish, lstrlen(szCode), (unsigned char*)szCode);

	__asm
	{
		mov dword ptr [szCode], 0x9b268187
		push 0
		call time
		add esp, 4
		mov	ecx, eax
		mov	eax, 0C22E4507h
		mul	ecx
		mov	eax, edx
		and eax, 0FFFF0000h
		sub eax, 29600000h
		mov dword ptr [szCode+4], eax		
	}
	BF_encrypt((unsigned long*)szCode, &blowfish);

	/* Convert the encrypted data to 4 words of 4 bytes each */
	__asm
	{
		lea esi, szCode
		movzx eax, word ptr [szCode+4]
		push eax
		lea esi, szCode
		movzx eax, word ptr [szCode+6]
		push eax
		lea esi, szCode
		movzx eax, word ptr [szCode]
		push eax
		lea esi, szCode
		movzx eax, word ptr [szCode+2]
		push eax
	}
	wsprintf(szCode, "%04X-%04X-%04X-%04X");
	__asm add esp, 4*4
}

void EntryPoint()
{
	hInst = GetModuleHandle(NULL);
	ExitProcess(DialogBoxParam((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_MAINDLG), 0, (DLGPROC)MainHandler, IDD_MAINDLG));
}

void CenterDialog(HWND hwndDlg)
{
	RECT Dlg, Desktop;
	DWORD Height, Width, DeskX, DeskY;
	GetWindowRect(hwndDlg, &Dlg);
	GetWindowRect(GetDesktopWindow(), &Desktop);
	Width = Dlg.right - Dlg.left;
	Height = Dlg.bottom - Dlg.top;
	DeskX = (Desktop.right - Width) >> 1;
	DeskY = (Desktop.bottom - Height) >> 1;	
	MoveWindow(hwndDlg, DeskX, DeskY, Width, Height, NULL);
}

BOOL CALLBACK MainHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	int Length;

	switch(uMsg)
	{
		case WM_CTLCOLOREDIT:
			if ((DWORD)lParam == (DWORD)GetDlgItem(hwndDlg, IDC_SERIAL))
			{
				SetBkColor((HDC)wParam, 0xC0C0C0);
				SetTextColor((HDC)wParam, NULL);
				CreateSolidBrush(0xC0C0C0);
			}
			break;
		case WM_INITDIALOG:
			_putenv("TZ=GMT0");
			CenterDialog(hwndDlg);
			SendDlgItemMessageA(hwndDlg, IDC_NAME, EM_SETLIMITTEXT, MAX_NAME_LEN-1, NULL);
			SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)"Please enter your name in the editbox above...");			
			SetFocus(GetDlgItem(hwndDlg, IDC_NAME));
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
				case IDC_EXIT:
					EndDialog(hwndDlg, NULL);
					break;
				case IDC_NAME:
					if (HIWORD(wParam) == EN_UPDATE)
					{	
						Length = SendDlgItemMessage(hwndDlg, IDC_NAME, WM_GETTEXT, MAX_NAME_LEN, (LPARAM)szName);
						if (Length)
						{
							Calculate(Length);
							SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)szCode);
						}
						else
						{
							SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)"Please enter your name in the editbox above...");
							break;
						}
					}
					break;
				case IDC_ABOUT:
					DialogBoxParam((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_ABOUTDLG), hwndDlg, (DLGPROC)AboutHandler, IDD_ABOUTDLG);
				default:
					DefWindowProc(hwndDlg, uMsg, wParam, lParam);
			}
			break;
		default:
			DefWindowProc(hwndDlg, uMsg, wParam, lParam);
	}
	return(FALSE);
}

BOOL CALLBACK AboutHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_INITDIALOG:
			CenterDialog(hwndDlg);
			break;
		case WM_COMMAND:
			if (wParam == IDC_CLOSE) EndDialog(hwndDlg, NULL);
			break;
		default:
			DefWindowProc(hwndDlg, uMsg, wParam, lParam);
	};
	return(FALSE);
};