#include "windows.h"
#include "resource.h"
#include "sha.h"

#define MAX_NAME_LEN 0x20

char szName  [0x40]={0};
char szCompa [0x40]={0};
char szMail  [0x40]={0};

char szMax   [0x10]={0};
char szComp  [0x40]={0};
char szType  [0x40]={0};
char szOS    [0x40]={0};
char szAccess[0x40]={0};
char szLang  [0x10]={0};
char szBoom  [0x40]={0};
char szCode  [0x300]={0};

unsigned char szAppend[16] = {
	0xC0, 0xEB, 0x19, 0x8B, 0x44,
    0x25, 0x14, 0x8B, 0x7C, 0x24,
	0x64, 0x50, 0xE8, 0x83, 0x2F,
	0
};

HANDLE hInst;

void EntryPoint();
void CenterDialog(HWND hwndDlg);
BOOL CALLBACK MainHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK AboutHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);

void Calculate(HWND hwnd)
{
	HKEY reghnd;
	unsigned int k, i;
	unsigned char *p;
	if (IsDlgButtonChecked(hwnd, IDC_RADIO1)) lstrcpy(szType, "SingleUser"); else lstrcpy(szType, "MultiKeys");
	lstrcpy(szLang, "Russian");
	lstrcpy(szAccess, "ReadWrite");
	lstrcpy(szMax, "0");

	RegCreateKey(HKEY_LOCAL_MACHINE, "Software\\PhysTechSoft\\StrongDisk\\parameters", &reghnd);
	if (IsDlgButtonChecked(hwnd, IDC_RADIO3)) lstrcpy(szOS, "Workstation"); else lstrcpy(szOS, "Server");	

	RegSetValueEx(reghnd, "MaxSize", NULL, REG_SZ, (unsigned char*)szMax, 2);
	RegSetValueEx(reghnd, "Count", NULL, REG_SZ, (unsigned char*)"999", 4);
	RegSetValueEx(reghnd, "DateBeg", NULL, REG_SZ, (unsigned char*)"19800101", 9);
	RegSetValueEx(reghnd, "DateEnd", NULL, REG_SZ, (unsigned char*)"21001231", 9);
	RegSetValueEx(reghnd, "Version", NULL, REG_SZ, (unsigned char*)"2", 2);
	RegSetValueEx(reghnd, "Language", NULL, REG_SZ, (unsigned char*)szLang, lstrlen(szLang)+1);
	RegSetValueEx(reghnd, "CryptoVer", NULL, REG_SZ, (unsigned char*)"SHA", 4);
	RegSetValueEx(reghnd, "ProdType", NULL, REG_SZ, (const BYTE*)szType, lstrlen(szType)+1);
	RegSetValueEx(reghnd, "SrvWork", NULL, REG_SZ, (const BYTE*)szOS, lstrlen(szOS)+1);
	RegSetValueEx(reghnd, "Access", NULL, REG_SZ, (const BYTE*)szAccess, lstrlen(szAccess)+1);

	SendDlgItemMessage(hwnd, IDC_NAME, WM_GETTEXT, MAX_NAME_LEN+1, (LPARAM)szName);
	RegSetValueEx(reghnd, "Owner", NULL, REG_SZ, (const BYTE*)szName, lstrlen(szName)+1);
	SendDlgItemMessage(hwnd, IDC_COMP, WM_GETTEXT, MAX_NAME_LEN+1, (LPARAM)szCompa);
	RegSetValueEx(reghnd, "Company", NULL, REG_SZ, (const BYTE*)szCompa, lstrlen(szCompa)+1);
	SendDlgItemMessage(hwnd, IDC_MAIL, WM_GETTEXT, MAX_NAME_LEN+1, (LPARAM)szMail);
	RegSetValueEx(reghnd, "Mail", NULL, REG_SZ, (const BYTE*)szMail, lstrlen(szMail)+1);

	k = 0x40;
	GetComputerName(szComp, (LPDWORD)&k);
	CharUpper(szComp);
	RegSetValueEx(reghnd, "Computer", NULL, REG_SZ, (const BYTE*)szComp, lstrlen(szComp)+1);
	lstrcpy(szCode, szComp);	
	k = MAX_NAME_LEN-lstrlen(szCode);
	RegQueryValueEx(reghnd, "DateBeg", NULL, NULL, (LPBYTE)(szCode + lstrlen(szCode)), (LPDWORD)&k);
	k = MAX_NAME_LEN-lstrlen(szCode);
	RegQueryValueEx(reghnd, "DateEnd", NULL, NULL, (LPBYTE)(szCode + lstrlen(szCode)), (LPDWORD)&k);
	lstrcat(szCode, (char*)szAppend);

	p=SHA1((unsigned char*)szCode, lstrlen(szCode), NULL);

	for (k=0, i=0; k<15; k++)
	{
		szBoom[k] = (p[k] % 0x0A) + 0x30;
		i ^= szBoom[k];
		szBoom[k+1] = (i % 0x0A) + 0x30;
	}

	RegSetValueEx(reghnd, "SerialKey", NULL, REG_SZ, (const BYTE*)szBoom, lstrlen(szBoom)+1);
	
	ZeroMemory(szCode, 0x300);
	lstrcpy(szCode, "2");
	lstrcpy(szCode+(32*1), szOS);
	lstrcpy(szCode+(32*2), szBoom);
	lstrcpy(szCode+(32*3), szType);
	lstrcpy(szCode+(32*4), szName);
	lstrcpy(szCode+(32*5), szMax);
	lstrcpy(szCode+(32*6), szMail);
	lstrcpy(szCode+(32*7), szLang);
	lstrcpy(szCode+(32*8), "SHA");
	lstrcpy(szCode+(32*9), "999");
	lstrcpy(szCode+(32*10), szCompa);
	lstrcpy(szCode+(32*11), "ReadWrite");
	lstrcpy(szCode+(32*12), (char*)szAppend);
	p=SHA1((unsigned char*)szCode, 0x1A0, NULL);

	for (k=0, i=0; k<15; k++)
	{
		szBoom[k] = (p[k] % 0x0A) + 0x30;
		i ^= szBoom[k];
		szBoom[k+1] = (i % 0x0A) + 0x30;
	}

	RegSetValueEx(reghnd, "RegistKey", NULL, REG_SZ, (const BYTE*)szBoom, lstrlen(szBoom)+1);
	RegCloseKey(reghnd);
	lstrcpy(szCode, "Machine specific registration info has been imported into the registry!");
}

void EntryPoint()
{
	hInst = GetModuleHandle(NULL);
	ExitProcess(DialogBoxParam((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_MAINDLG), 0, (DLGPROC)MainHandler, IDD_MAINDLG));
}

void CenterDialog(HWND hwndDlg)
{
	RECT Dlg, Desktop;
	DWORD Height, Width, DeskX, DeskY;
	GetWindowRect(hwndDlg, &Dlg);
	GetWindowRect(GetDesktopWindow(), &Desktop);
	Width = Dlg.right - Dlg.left;
	Height = Dlg.bottom - Dlg.top;
	DeskX = (Desktop.right - Width) >> 1;
	DeskY = (Desktop.bottom - Height) >> 1;	
	MoveWindow(hwndDlg, DeskX, DeskY, Width, Height, NULL);
}

BOOL CALLBACK MainHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	OSVERSIONINFO OVI;
	switch(uMsg)
	{
		case WM_CTLCOLOREDIT:
			if ((DWORD)lParam == (DWORD)GetDlgItem(hwndDlg, IDC_SERIAL))
			{
				SetBkColor((HDC)wParam, 0xC0C0C0);
				SetTextColor((HDC)wParam, NULL);
				CreateSolidBrush(0xC0C0C0);
			}
			break;
		case WM_INITDIALOG:
			srand(GetTickCount());
			CenterDialog(hwndDlg);
			OVI.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
			GetVersionEx(&OVI);
			CheckDlgButton(hwndDlg, IDC_RADIO1, 1);			
			if (OVI.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS)	CheckDlgButton(hwndDlg, IDC_RADIO3, 1); else CheckDlgButton(hwndDlg, IDC_RADIO4, 1);
			SendDlgItemMessage(hwndDlg, IDC_NAME, EM_SETLIMITTEXT, MAX_NAME_LEN, NULL);
			SendDlgItemMessage(hwndDlg, IDC_COMP, EM_SETLIMITTEXT, MAX_NAME_LEN, NULL);
			SendDlgItemMessage(hwndDlg, IDC_MAIL, EM_SETLIMITTEXT, MAX_NAME_LEN, NULL);
			SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)"Please insert registration information and choose license type...");
			SetFocus(GetDlgItem(hwndDlg, IDC_NAME));
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
				case IDC_RADIO1:
					CheckDlgButton(hwndDlg, IDC_RADIO2, 0);					
					break;
				case IDC_RADIO2:
					CheckDlgButton(hwndDlg, IDC_RADIO1, 0);					
					break;
				case IDC_RADIO3:
					CheckDlgButton(hwndDlg, IDC_RADIO4, 0);					
					break;
				case IDC_RADIO4:
					CheckDlgButton(hwndDlg, IDC_RADIO3, 0);					
					break;
				case IDC_EXIT:
					Calculate(hwndDlg);
					SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)szCode);			
					break;
				case IDC_ABOUT:
					DialogBoxParam((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_ABOUTDLG), hwndDlg, (DLGPROC)AboutHandler, IDD_ABOUTDLG);
				default:
					DefWindowProc(hwndDlg, uMsg, wParam, lParam);
			}
			break;
		default:
			DefWindowProc(hwndDlg, uMsg, wParam, lParam);
	};
	return(FALSE);
}

BOOL CALLBACK AboutHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_INITDIALOG:
			CenterDialog(hwndDlg);
			break;
		case WM_COMMAND:
			if (wParam == IDC_CLOSE) EndDialog(hwndDlg, NULL);
			break;
		default:
			DefWindowProc(hwndDlg, uMsg, wParam, lParam);
	};
	return(FALSE);
};